/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.wait;

import org.eclipse.reddeer.common.properties.RedDeerProperties;

public class TimePeriod {
    public static final TimePeriod NONE = new TimePeriod(0L);
    public static final TimePeriod SHORT = new TimePeriod(1L);
    public static final TimePeriod MEDIUM = new TimePeriod(3L);
    public static final TimePeriod DEFAULT = new TimePeriod(10L);
    public static final TimePeriod LONG = new TimePeriod(60L);
    public static final TimePeriod VERY_LONG = new TimePeriod(300L);
    public static final TimePeriod ETERNAL = new TimePeriod(Long.MAX_VALUE);
    private static Float FACTOR = Float.valueOf(RedDeerProperties.TIME_PERIOD_FACTOR.getFloatValue());
    private long seconds;

    private TimePeriod(long seconds) {
        this.seconds = seconds;
    }

    public long getSeconds() {
        if (this.seconds == Long.MAX_VALUE || this.seconds == 0L) {
            return this.seconds;
        }
        if (FACTOR.floatValue() == 1.0f) {
            return this.seconds;
        }
        if ((float)this.seconds >= 9.223372E18f / FACTOR.floatValue()) {
            return Long.MAX_VALUE;
        }
        return Math.round((double)this.seconds * (double)FACTOR.floatValue());
    }

    public static TimePeriod getCustom(long seconds) {
        if (seconds < 0L) {
            throw new IllegalArgumentException("Time in seconds has to be positive number");
        }
        return new TimePeriod(seconds);
    }

    public String toString() {
        return "Time period " + this.seconds + " s (factor " + FACTOR + " was used).";
    }

    public static void updateFactor() {
        FACTOR = Float.valueOf(RedDeerProperties.TIME_PERIOD_FACTOR.getFloatValue());
    }
}

