/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.dialogs;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.reddeer.core.handler.CompositeHandler;
import org.eclipse.reddeer.jface.dialogs.MessageTypeEnum;
import org.eclipse.reddeer.jface.window.AbstractWindow;
import org.eclipse.reddeer.jface.window.Openable;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.impl.label.DefaultLabel;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;

public class TitleAreaDialog
extends AbstractWindow {
    private CompositeHandler handler = CompositeHandler.getInstance();

    public TitleAreaDialog(Shell shell) {
        super(shell);
    }

    public TitleAreaDialog(Matcher<?> ... matchers) {
        super(matchers);
    }

    public TitleAreaDialog(String text) {
        super(text);
    }

    public TitleAreaDialog() {
    }

    public String getTitle() {
        this.checkShell();
        Control labelControl = this.handler.getChildren(this.getShellComposite())[2];
        return new DefaultLabel((Label)labelControl).getText();
    }

    public String getMessage() {
        this.checkShell();
        String message = this.getMessageLabel().getText();
        if (this.getMessageImage() != null) {
            message = message.substring(1);
        }
        return message;
    }

    public MessageTypeEnum getMessageType() {
        this.checkShell();
        Image messageImage = this.getMessageImage();
        if (messageImage == null) {
            return MessageTypeEnum.NONE;
        }
        if (messageImage.equals((Object)JFaceResources.getImage((String)"dialog_message_error_image"))) {
            return MessageTypeEnum.ERROR;
        }
        if (messageImage.equals((Object)JFaceResources.getImage((String)"dialog_messasge_info_image"))) {
            return MessageTypeEnum.INFO;
        }
        if (messageImage.equals((Object)JFaceResources.getImage((String)"dialog_messasge_warning_image"))) {
            return MessageTypeEnum.WARNING;
        }
        return MessageTypeEnum.UNKNOWN;
    }

    public Image getMessageImage() {
        this.checkShell();
        Control imageControl = this.handler.getChildren(this.getShellComposite())[3];
        return new DefaultLabel((Label)imageControl).getImage();
    }

    public Image getTitleImage() {
        this.checkShell();
        Control imageControl = this.handler.getChildren(this.getShellComposite())[1];
        return new DefaultLabel((Label)imageControl).getImage();
    }

    protected org.eclipse.reddeer.swt.api.Text getMessageLabel() {
        Control textControl = this.handler.getChildren(this.getShellComposite())[4];
        return new DefaultText((Text)textControl);
    }

    protected Composite getShellComposite() {
        return (Composite)this.handler.getChildren((Composite)this.getShell().getSWTWidget())[0];
    }

    @Override
    public Class<? extends Window> getEclipseClass() {
        return org.eclipse.jface.dialogs.TitleAreaDialog.class;
    }

    @Override
    public Openable getDefaultOpenAction() {
        return null;
    }
}

