/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.AfterClass;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class RunAfterClasses
extends AbstractStatementWithScreenshot {
    private final List<FrameworkMethod> afterClasses;
    private Requirements requirements;

    public RunAfterClasses(String config, Statement next, TestClass testClass, Requirements requirements) {
        super(config, next, testClass, null, null);
        this.afterClasses = testClass.getAnnotatedMethods(AfterClass.class);
        this.requirements = requirements;
    }

    public void evaluate() throws Throwable {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.nextStatement.evaluate();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        try {
            Iterator<FrameworkMethod> iterator = this.afterClasses.iterator();
            while (iterator.hasNext()) {
                FrameworkMethod each;
                this.frameworkMethod = each = iterator.next();
                this.frameworkMethod.invokeExplosively(this.target, new Object[0]);
            }
            this.requirements.runAfterClass();
        }
        catch (Throwable e) {
            if (ScreenshotCapturer.shouldCaptureScreenshotOnException(e)) {
                if (this.isClassLevel()) {
                    this.createScreenshot("AfterClass");
                } else {
                    this.createScreenshot("After");
                }
            }
            errors.add(e);
        }
        MultipleFailureException.assertEmpty(errors);
    }
}

