/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.requirement.configuration;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.junit.configuration.RedDeerConfigurationException;
import org.eclipse.reddeer.junit.internal.configuration.reader.JSONConfigurationReader;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfiguration;

public class RequirementConfigurationPool {
    private static RequirementConfigurationPool instance;
    private List<RequirementConfiguration> requirementsConfigurations = new ArrayList<RequirementConfiguration>();

    private RequirementConfigurationPool() {
        this.initRequirementConfigurationPool();
    }

    private void initRequirementConfigurationPool() {
        if (RequirementConfigurationPool.getConfigurationFile() != null) {
            JSONConfigurationReader reader = new JSONConfigurationReader();
            this.requirementsConfigurations.addAll(reader.loadConfigurations(RequirementConfigurationPool.getConfigurationFile()));
        }
    }

    public static File getConfigurationFile() {
        String fileLocation = RedDeerProperties.CONFIG_FILE.getValue();
        if (fileLocation == null) {
            return null;
        }
        File configFile = new File(fileLocation);
        if (!configFile.exists()) {
            throw new RedDeerConfigurationException("The configuration location " + fileLocation + " does not exist");
        }
        if (configFile.isFile()) {
            return configFile;
        }
        throw new RedDeerConfigurationException("The configuration location " + fileLocation + " must be a regular file");
    }

    public static RequirementConfigurationPool getInstance() {
        if (instance == null) {
            instance = new RequirementConfigurationPool();
        }
        return instance;
    }

    public static void destroyPool() {
        if (instance != null) {
            instance = null;
        }
    }

    public void setRequirementsConfigurations(List<RequirementConfiguration> configurations) {
        this.requirementsConfigurations = configurations;
    }

    public void addRequirementsConfigurations(List<RequirementConfiguration> configurations) {
        this.getRequirementsConfigurations().addAll(configurations);
    }

    public List<RequirementConfiguration> getRequirementsConfigurations() {
        return Collections.unmodifiableList(this.requirementsConfigurations);
    }

    public List<RequirementConfiguration> getConfigurations(Class<? extends RequirementConfiguration> configClass) {
        ArrayList<RequirementConfiguration> suitableConfigs = new ArrayList<RequirementConfiguration>();
        for (RequirementConfiguration config : this.requirementsConfigurations) {
            if (!configClass.isAssignableFrom(config.getClass())) continue;
            suitableConfigs.add(config);
        }
        return this.deepCopyList(suitableConfigs);
    }

    private List<RequirementConfiguration> deepCopyList(List<RequirementConfiguration> listToCopy) {
        ArrayList<RequirementConfiguration> result = new ArrayList<RequirementConfiguration>();
        for (RequirementConfiguration configuraiton : listToCopy) {
            RequirementConfiguration copiedConfig = this.deepCopyConfiguration(configuraiton);
            if (copiedConfig == null) {
                result.add(configuraiton);
                continue;
            }
            result.add(copiedConfig);
        }
        return result;
    }

    private <T extends RequirementConfiguration> T deepCopyConfiguration(T configuration) {
        try {
            return (T)((RequirementConfiguration)configuration.getClass().getConstructor(configuration.getClass()).newInstance(configuration));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }
}

