/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.screenshot;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.reddeer.common.exception.RedDeerException;

public class ImageTool {
    private static ImageTool instance;

    private ImageTool() {
    }

    public static ImageTool getInstance() {
        if (instance == null) {
            instance = new ImageTool();
        }
        return instance;
    }

    public boolean isImageBlank(String filePath) {
        BufferedImage img;
        try {
            img = ImageIO.read(new File(filePath));
        }
        catch (IOException e) {
            throw new RedDeerException("Cannot read image file " + filePath, (Throwable)e);
        }
        int width = img.getWidth();
        int height = img.getHeight();
        Color first = new Color(img.getRGB(0, 0));
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                int rgb = img.getRGB(i, j);
                Color c = new Color(rgb);
                if (!c.equals(first)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

