/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.tree;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.TreeHandler;
import org.eclipse.reddeer.core.handler.TreeItemHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.swt.widgets.AbstractControl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.Matcher;

public abstract class AbstractTree
extends AbstractControl<Tree>
implements org.eclipse.reddeer.swt.api.Tree {
    private static final Logger logger = Logger.getLogger(AbstractTree.class);

    protected AbstractTree(ReferencedComposite refComposite, int index, Matcher<?> ... matchers) {
        super(Tree.class, refComposite, index, matchers);
    }

    protected AbstractTree(Tree tree) {
        super(tree);
    }

    @Override
    public List<TreeItem> getAllItems() {
        LinkedList<TreeItem> list = new LinkedList<TreeItem>();
        list.addAll(this.getAllItemsRecursive(this.getItems()));
        return list;
    }

    @Override
    public List<TreeItem> getItems() {
        LinkedList<TreeItem> items = new LinkedList<TreeItem>();
        List eclipseItems = TreeHandler.getInstance().getSWTItems((Tree)this.swtWidget);
        for (org.eclipse.swt.widgets.TreeItem swtTreeItem : eclipseItems) {
            DefaultTreeItem item = null;
            try {
                item = new DefaultTreeItem(swtTreeItem);
                items.addLast(item);
            }
            catch (RedDeerException e) {
                if (TreeHandler.getInstance().isDisposed((Widget)swtTreeItem)) continue;
                throw e;
            }
        }
        return items;
    }

    @Override
    public TreeItem getItem(String ... itemPath) {
        return new DefaultTreeItem((org.eclipse.reddeer.swt.api.Tree)this, itemPath);
    }

    @Override
    public TreeItem getItem(Matcher<org.eclipse.swt.widgets.TreeItem> ... itemMatchers) {
        return new DefaultTreeItem((org.eclipse.reddeer.swt.api.Tree)this, itemMatchers);
    }

    @Override
    public void selectItems(TreeItem ... treeItems) {
        logger.info("Select specified tree items");
        org.eclipse.swt.widgets.TreeItem[] items = new org.eclipse.swt.widgets.TreeItem[treeItems.length];
        int i = 0;
        while (i < treeItems.length) {
            items[i] = (org.eclipse.swt.widgets.TreeItem)treeItems[i].getSWTWidget();
            ++i;
        }
        TreeItemHandler.getInstance().selectItems(items);
    }

    @Override
    public List<TreeItem> getSelectedItems() {
        ArrayList<TreeItem> selectedItems = new ArrayList<TreeItem>();
        org.eclipse.swt.widgets.TreeItem[] treeItemArray = TreeHandler.getInstance().getSelection((Tree)this.swtWidget);
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                org.eclipse.swt.widgets.TreeItem swtItem = treeItemArray[n2];
                DefaultTreeItem item = null;
                try {
                    item = new DefaultTreeItem(swtItem);
                    selectedItems.add(item);
                }
                catch (RedDeerException e) {
                    if (TreeHandler.getInstance().isDisposed((Widget)swtItem)) break block3;
                    throw e;
                }
            }
            ++n2;
        }
        return selectedItems;
    }

    @Override
    public void setFocus() {
        TreeHandler.getInstance().setFocus((Control)this.swtWidget);
    }

    @Override
    public int getColumnCount() {
        return TreeHandler.getInstance().getColumnCount((Tree)this.swtWidget);
    }

    @Override
    public List<String> getHeaderColumns() {
        return TreeHandler.getInstance().getHeaderColumns((Tree)this.swtWidget);
    }

    @Override
    public void unselectAllItems() {
        logger.info("Unselect all tree items");
        TreeHandler.getInstance().unselectAllItems((Tree)this.swtWidget);
    }

    private List<TreeItem> getAllItemsRecursive(List<TreeItem> parentItems) {
        LinkedList<TreeItem> list = new LinkedList<TreeItem>();
        for (TreeItem item : parentItems) {
            list.add(item);
            list.addAll(this.getAllItemsRecursive(item.getItems()));
        }
        return list;
    }
}

