/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.api.ui.compile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.internal.useractions.Activator;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompilableSource;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileType;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class SystemCompileAction
extends SystemBaseAction {
    private SystemCompileCommand compileCmd;
    private boolean isPrompt;
    static /* synthetic */ Class class$0;

    public SystemCompileAction(Shell shell, SystemCompileCommand compileCommand, boolean isPrompt) {
        super(isPrompt ? String.valueOf(compileCommand.getLabel()) + "..." : compileCommand.getLabel(), compileCommand.getLabel(), Activator.getDefault().getImageDescriptor("COMPILE_1"), shell);
        this.compileCmd = compileCommand;
        this.isPrompt = isPrompt;
        SystemCompileManager mgr = compileCommand.getParentType().getParentProfile().getParentManager();
        this.allowOnMultipleSelection(mgr.isMultiSelectSupported(compileCommand));
        if (isPrompt) {
            this.setHelp("org.eclipse.rse.ui.scpa0000");
        } else {
            this.setHelp("org.eclipse.rse.ui.scna0000");
        }
        SystemCompileCommand lucc = this.compileCmd.getParentType().getLastUsedCompileCommand();
        if (lucc != null && lucc.getLabel().equals(this.compileCmd.getLabel())) {
            this.setChecked(true);
        } else {
            this.setChecked(false);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        Object selected = this.getFirstSelection();
        if (selected == null) {
            return false;
        }
        ISystemRemoteElementAdapter rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)selected);
        if (rmtAdapter == null) {
            enable = false;
        }
        if (!enable) {
            return false;
        }
        SystemCompileManager mgr = this.compileCmd.getParentType().getParentProfile().getParentManager();
        while (enable && selected != null) {
            enable = mgr.isCompilable(selected);
            selected = this.getNextSelection();
        }
        return enable;
    }

    public boolean checkObjectType(Object selectedObject) {
        ISystemRemoteElementAdapter rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)selectedObject);
        if (rmtAdapter == null) {
            return false;
        }
        return rmtAdapter.getSubSystem(selectedObject).isConnected();
    }

    public void run() {
        if (this.checkDirtyEditors()) {
            Object element = this.getFirstSelection();
            boolean ok = true;
            while (ok && element != null) {
                SystemCompilableSource compilableSrc;
                SystemCompileType compType = this.compileCmd.getParentType();
                if (!this.compileCmd.equals(compType.getLastUsedCompileCommand())) {
                    compType.setLastUsedCompileCommand(this.compileCmd);
                    compType.getParentProfile().writeToDisk();
                }
                if (!(ok = (compilableSrc = compType.getParentProfile().getCompilableSourceObject(this.getShell(), element, this.compileCmd, this.isPrompt, this.viewer)).runCompileCommand())) continue;
                element = this.getNextSelection();
            }
        }
    }

    protected List getDirtyEditors() {
        IStructuredSelection sel = this.getSelection();
        List selection = sel.toList();
        ArrayList<ISystemEditableRemoteObject> dirtyEditors = new ArrayList<ISystemEditableRemoteObject>();
        int i = 0;
        while (i < selection.size()) {
            ISystemEditableRemoteObject editable;
            Object selected = selection.get(i);
            if (selected instanceof IAdaptable && (editable = this.getEditableFor((IAdaptable)selected)) != null) {
                try {
                    if (editable.checkOpenInEditor() == 0) {
                        editable.openEditor();
                        if (editable.isDirty()) {
                            dirtyEditors.add(editable);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return dirtyEditors;
    }

    protected ISystemEditableRemoteObject getEditableFor(IAdaptable selected) {
        ISystemRemoteElementAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemRemoteElementAdapter)selected.getAdapter((Class)clazz)).canEdit((Object)selected)) {
            ISystemEditableRemoteObject editable = adapter.getEditableRemoteObject((Object)selected);
            try {
                editable.setLocalResourceProperties();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return editable;
        }
        return null;
    }

    protected boolean checkDirtyEditors() {
        List dirtyEditors = this.getDirtyEditors();
        if (dirtyEditors.size() > 0) {
            AdaptableList input = new AdaptableList();
            int i = 0;
            while (i < dirtyEditors.size()) {
                ISystemEditableRemoteObject rmtObj = (ISystemEditableRemoteObject)dirtyEditors.get(i);
                input.add(rmtObj.getRemoteObject());
                ++i;
            }
            WorkbenchContentProvider cprovider = new WorkbenchContentProvider();
            SystemTableViewProvider lprovider = new SystemTableViewProvider(null);
            ListSelectionDialog dlg = new ListSelectionDialog(this.getShell(), (Object)input, (IStructuredContentProvider)cprovider, (ILabelProvider)lprovider, SystemUDAResources.EditorManager_saveResourcesMessage);
            dlg.setInitialSelections(input.getChildren());
            dlg.setTitle(SystemUDAResources.EditorManager_saveResourcesTitle);
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            Object[] filesToSave = dlg.getResult();
            int s = 0;
            while (s < filesToSave.length) {
                IAdaptable rmtObj = (IAdaptable)filesToSave[s];
                ISystemEditableRemoteObject editable = this.getEditableFor(rmtObj);
                editable.doImmediateSaveAndUpload();
                ++s;
            }
        }
        return true;
    }
}

