/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.simpleproject;

import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.PlatformNlsFile;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.WorkspaceNlsFile;

public abstract class AbstractNlsFile {
    public static final String MANIFEST_CLASS = "Nls-Class";
    private final IProject m_project;
    private String m_nlsTypeName;

    protected AbstractNlsFile(IFile file) {
        this.m_project = file.getProject();
        this.parseInput(file);
    }

    public abstract boolean isReadOnly();

    public static AbstractNlsFile loadNlsFile(IFile file) {
        if (file == null || !file.exists()) {
            return null;
        }
        if (file.isReadOnly()) {
            return new PlatformNlsFile(file);
        }
        return new WorkspaceNlsFile(file);
    }

    protected void parseInput(IFile file) {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream io = file.getContents();){
                props.load(io);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            SdkLog.warning((String)"could not open stream to read NLS file '{}'.", (Object[])new Object[]{file.getFullPath(), e});
        }
        this.m_nlsTypeName = props.getProperty(MANIFEST_CLASS);
    }

    public String getNlsTypeName() {
        return this.m_nlsTypeName;
    }

    public IProject getProject() {
        return this.m_project;
    }
}

