/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.s.jaxws.ParsedWsdl;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.operation.jaxws.WebServiceNewOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebServiceFormPageInput
implements Comparable<WebServiceFormPageInput> {
    private final IJavaProject m_javaProject;
    private final int m_hash;
    private final String m_displayName;
    private final Map<IType, ITypeHierarchy> m_superHierarchyCache;
    private final Map<IType, ITypeHierarchy> m_hierarchyCache;
    private final IFile m_wsdl;
    private final List<IFile> m_bindings;
    private final Map<IType, Set<IType>> m_portTypes;
    private final Map<IType, QName> m_portTypeNamesInWsdl;
    private final Map<IType, QName> m_webServices;
    private final List<IFile> m_jaxwsBindingFiles;
    private ParsedWsdl m_servicesFromWsdl;
    private final Map<IType, IType> m_webServiceClients;
    private final Map<IType, IType> m_entryPoints;
    private final Map<IType, IType> m_entryPointDefinitions;
    private final Map<IType, IType> m_serviceImplementations;
    private final Map<IType, String> m_entryPointNameFromDefinitions;
    private final Map<IType, String> m_entryPointPackageFromDefinitions;
    private final Map<IType, IType> m_authMethodFromDefinitions;
    private final Map<IType, IType> m_authVerifierFromDefinitions;
    private final Map<IType, List<IType>> m_handlersFromDefinitions;

    public WebServiceFormPageInput(IFile wsdl, IJavaProject javaProject) {
        this.m_wsdl = (IFile)Validate.notNull((Object)wsdl);
        Validate.isTrue((boolean)this.m_wsdl.exists());
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)javaProject));
        this.m_javaProject = javaProject;
        this.m_displayName = this.calcDisplayName();
        this.m_hash = this.m_wsdl.hashCode();
        int defaultSize = 3;
        this.m_bindings = new ArrayList<IFile>(defaultSize);
        this.m_jaxwsBindingFiles = new ArrayList<IFile>(defaultSize);
        this.m_webServices = new HashMap<IType, QName>(defaultSize);
        this.m_superHierarchyCache = new HashMap<IType, ITypeHierarchy>(defaultSize);
        this.m_hierarchyCache = new HashMap<IType, ITypeHierarchy>(defaultSize);
        this.m_webServiceClients = new HashMap<IType, IType>(defaultSize);
        this.m_entryPoints = new HashMap<IType, IType>(defaultSize);
        this.m_portTypes = new HashMap<IType, Set<IType>>(defaultSize);
        this.m_serviceImplementations = new HashMap<IType, IType>(defaultSize);
        this.m_entryPointDefinitions = new HashMap<IType, IType>(defaultSize);
        this.m_entryPointNameFromDefinitions = new HashMap<IType, String>(defaultSize);
        this.m_entryPointPackageFromDefinitions = new HashMap<IType, String>(defaultSize);
        this.m_authMethodFromDefinitions = new HashMap<IType, IType>(defaultSize);
        this.m_authVerifierFromDefinitions = new HashMap<IType, IType>(defaultSize);
        this.m_handlersFromDefinitions = new HashMap<IType, List<IType>>(defaultSize);
        this.m_portTypeNamesInWsdl = new HashMap<IType, QName>(defaultSize);
    }

    public void load(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)("Parse artifacts of " + this.getWsdl().getName()), (int)120);
        S2eUtils.waitForJdt();
        this.loadWsdlServices();
        progress.worked(50);
        this.loadWebServicesAndPortTypes();
        progress.worked(10);
        this.loadBindings();
        progress.worked(10);
        this.loadJaxwsBindingFile();
        progress.worked(10);
        this.loadWebServiceClient();
        progress.worked(10);
        this.loadEntryPoint();
        progress.worked(10);
        this.loadEntryPointDefinitions();
        progress.worked(10);
        this.loadServiceImplementations();
        progress.worked(10);
    }

    protected String calcDisplayName() {
        String ext;
        String name = this.getWsdl().getName();
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos > 0 && (ext = this.getWsdl().getFileExtension()) != null) {
            name = name.substring(0, name.length() - ext.length() - 1);
        }
        name = JaxWsUtils.removeCommonSuffixes((String)name);
        String camelToWords = Pattern.compile("([A-Z])").matcher(name).replaceAll(" $1");
        camelToWords = Pattern.compile("[^A-Za-z0-9\\s]").matcher(camelToWords).replaceAll(" ").trim();
        String[] words = camelToWords.split("\\s");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            if (StringUtils.isNotBlank((CharSequence)w)) {
                builder.append(CoreUtils.ensureStartWithUpperCase((String)w)).append(' ');
            }
            ++n2;
        }
        return builder.toString().trim();
    }

    protected void loadWsdlServices() throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = this.getWsdl().getContents();){
                this.setServicesFromWsdl(ParsedWsdl.create((URI)this.getWsdl().getLocation().toFile().toURI(), (InputStream)in, (boolean)false));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | WSDLException e) {
            throw new CoreException((IStatus)new ScoutStatus(e));
        }
    }

    protected void loadWebServiceClient() throws JavaModelException {
        Predicate<IType> webServiceClientsFilter = new Predicate<IType>(){

            @Override
            public boolean test(IType element) {
                try {
                    ITypeHierarchy superTypeHierarchy = WebServiceFormPageInput.this.getSuperTypeHierarchy(element);
                    return S2eUtils.hierarchyContains((ITypeHierarchy)superTypeHierarchy, (String)"org.eclipse.scout.rt.server.jaxws.consumer.AbstractWebServiceClient");
                }
                catch (JavaModelException e) {
                    SdkLog.warning((String)"Unable to check if element '{}' is a web service client.", (Object[])new Object[]{element.getFullyQualifiedName(), e});
                    return false;
                }
            }
        };
        for (Set<IType> portTypes : this.m_portTypes.values()) {
            for (IType portType : portTypes) {
                IType webServiceClient = this.getPortTypeChildClass(portType, webServiceClientsFilter);
                if (!S2eUtils.exists((IJavaElement)webServiceClient)) continue;
                this.m_webServiceClients.put(portType, webServiceClient);
            }
        }
    }

    protected IType getPortTypeChildClass(IType portType, Predicate<IType> filter) throws JavaModelException {
        IType[] candidates;
        if (!S2eUtils.exists((IJavaElement)portType)) {
            return null;
        }
        IType[] iTypeArray = candidates = this.getTypeHierarchy(portType).getAllSubtypes(portType);
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (filter == null || filter.test(t)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    protected void loadEntryPoint() throws JavaModelException {
        Predicate<IType> portTypeFilter = new Predicate<IType>(){

            @Override
            public boolean test(IType element) {
                return S2eUtils.exists((IJavaElement)S2eUtils.getAnnotation((IAnnotatable)element, (String)"javax.jws.WebService"));
            }
        };
        for (Set<IType> portTypes : this.m_portTypes.values()) {
            for (IType portType : portTypes) {
                IType entryPoint = this.getPortTypeChildClass(portType, portTypeFilter);
                if (!S2eUtils.exists((IJavaElement)entryPoint)) continue;
                this.m_entryPoints.put(portType, entryPoint);
            }
        }
    }

    protected void loadEntryPointDefinitions() throws CoreException {
        Set<IType> webServiceEntryPointDefinitions = this.findAllTypesAnnotatedWith("org.eclipse.scout.rt.server.jaxws.provider.annotation.WebServiceEntryPoint");
        if (webServiceEntryPointDefinitions.isEmpty()) {
            return;
        }
        if (this.m_entryPoints.isEmpty()) {
            return;
        }
        for (Set<IType> portTypes : this.m_portTypes.values()) {
            for (IType portType : portTypes) {
                IType entryPoint = this.getEntryPoint(portType);
                if (!S2eUtils.exists((IJavaElement)entryPoint)) continue;
                String entryPointFqn = entryPoint.getFullyQualifiedName();
                for (IType entryPointDefCandidate : webServiceEntryPointDefinitions) {
                    this.loadEntryPointDefinition(entryPointDefCandidate, portType, entryPointFqn);
                }
            }
        }
    }

    protected void loadEntryPointDefinition(IType entryPointDefCandidate, IType portType, String entryPointFqn) throws JavaModelException {
        IAnnotation annotation = S2eUtils.getAnnotation((IAnnotatable)entryPointDefCandidate, (String)"org.eclipse.scout.rt.server.jaxws.provider.annotation.WebServiceEntryPoint");
        if (!S2eUtils.exists((IJavaElement)annotation)) {
            return;
        }
        String pck = S2eUtils.getAnnotationValueString((IAnnotation)annotation, (String)"entryPointPackage");
        String name = S2eUtils.getAnnotationValueString((IAnnotation)annotation, (String)"entryPointName");
        if (StringUtils.isBlank((CharSequence)pck)) {
            pck = Signature.getQualifier((String)entryPointDefCandidate.getFullyQualifiedName());
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = String.valueOf(portType.getElementName()) + "EntryPoint";
        }
        if (entryPointFqn.equals(String.valueOf(pck) + '.' + name)) {
            this.m_entryPointDefinitions.put(portType, entryPointDefCandidate);
            this.m_entryPointNameFromDefinitions.put(portType, name);
            this.m_entryPointPackageFromDefinitions.put(portType, pck);
            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                Object value;
                IMemberValuePair mvp = iMemberValuePairArray[n2];
                if ("authentication".equals(mvp.getMemberName())) {
                    value = mvp.getValue();
                    if (value instanceof IAnnotation) {
                        IAnnotation authentication = (IAnnotation)value;
                        IMemberValuePair[] iMemberValuePairArray2 = authentication.getMemberValuePairs();
                        n3 = iMemberValuePairArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemberValuePair authElement = iMemberValuePairArray2[n4];
                            if ("method".equals(authElement.getMemberName()) && authElement.getValueKind() == 10) {
                                this.m_authMethodFromDefinitions.put(portType, this.getClazzAnnotationValue((IAnnotation)authElement.getValue(), entryPointDefCandidate));
                            } else if ("verifier".equals(authElement.getMemberName()) && authElement.getValueKind() == 10) {
                                this.m_authVerifierFromDefinitions.put(portType, this.getClazzAnnotationValue((IAnnotation)authElement.getValue(), entryPointDefCandidate));
                            }
                            ++n4;
                        }
                    }
                } else if ("handlerChain".equals(mvp.getMemberName())) {
                    value = mvp.getValue();
                    if (value instanceof Object[]) {
                        Object[] values = (Object[])value;
                        ArrayList<IAnnotation> handlers = new ArrayList<IAnnotation>(values.length);
                        Object[] objectArray = values;
                        int n5 = values.length;
                        n3 = 0;
                        while (n3 < n5) {
                            Object o = objectArray[n3];
                            if (o instanceof IAnnotation) {
                                handlers.add((IAnnotation)o);
                            }
                            ++n3;
                        }
                        this.loadHandlersFromDefinition(handlers, entryPointDefCandidate, portType);
                    } else if (value instanceof IAnnotation) {
                        this.loadHandlersFromDefinition(Collections.singletonList((IAnnotation)value), entryPointDefCandidate, portType);
                    }
                }
                ++n2;
            }
        }
    }

    protected void loadHandlersFromDefinition(Collection<IAnnotation> handlers, IType owner, IType portType) throws JavaModelException {
        for (IAnnotation handler : handlers) {
            IMemberValuePair[] iMemberValuePairArray = handler.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation clazzAnnotation;
                IType handlerType;
                IMemberValuePair mvp = iMemberValuePairArray[n2];
                if ("value".equals(mvp.getMemberName()) && mvp.getValueKind() == 10 && S2eUtils.exists((IJavaElement)(handlerType = this.getClazzAnnotationValue(clazzAnnotation = (IAnnotation)mvp.getValue(), owner)))) {
                    List<IType> handlersOfPortType = this.m_handlersFromDefinitions.get(portType);
                    if (handlersOfPortType == null) {
                        handlersOfPortType = new ArrayList<IType>(3);
                        this.m_handlersFromDefinitions.put(portType, handlersOfPortType);
                    }
                    handlersOfPortType.add(handlerType);
                }
                ++n2;
            }
        }
    }

    protected IType getClazzAnnotationValue(IAnnotation clazzAnnotation, IType owner) throws JavaModelException {
        if (!S2eUtils.exists((IJavaElement)clazzAnnotation)) {
            return null;
        }
        String qualifiedName = S2eUtils.getAnnotationValueString((IAnnotation)clazzAnnotation, (String)"qualifiedName");
        IJavaProject javaProject = owner.getJavaProject();
        if (StringUtils.isNotBlank((CharSequence)qualifiedName)) {
            return javaProject.findType(qualifiedName);
        }
        String value = S2eUtils.getAnnotationValueString((IAnnotation)clazzAnnotation, (String)"value");
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        String nullClazzSimpleName = Signature.getSimpleName((String)"org.eclipse.scout.rt.server.jaxws.provider.annotation.Clazz$NullClazz".replace('$', '.'));
        if (value.equals(nullClazzSimpleName) || value.endsWith(String.valueOf('.') + nullClazzSimpleName) || value.endsWith(String.valueOf('$') + nullClazzSimpleName)) {
            return null;
        }
        return WebServiceFormPageInput.getReferencedType(owner, value);
    }

    protected static IType getReferencedType(IType declaringType, String typeName) throws JavaModelException {
        String[][] resolvedTypeName = declaringType.resolveType(typeName);
        if (resolvedTypeName == null || resolvedTypeName.length < 1) {
            return null;
        }
        IJavaProject javaProject = declaringType.getJavaProject();
        String[][] stringArray = resolvedTypeName;
        int n = resolvedTypeName.length;
        int n2 = 0;
        while (n2 < n) {
            String[] fqn = stringArray[n2];
            IType result = javaProject.findType(fqn[0], fqn[1]);
            if (S2eUtils.exists((IJavaElement)result)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    protected void loadServiceImplementations() throws JavaModelException {
        Predicate<IType> serviceImplFilter = new Predicate<IType>(){

            @Override
            public boolean test(IType element) {
                if (S2eUtils.exists((IJavaElement)S2eUtils.getAnnotation((IAnnotatable)element, (String)"javax.jws.WebService"))) {
                    return false;
                }
                try {
                    ITypeHierarchy superTypeHierarchy = WebServiceFormPageInput.this.getSuperTypeHierarchy(element);
                    return !S2eUtils.hierarchyContains((ITypeHierarchy)superTypeHierarchy, (String)"org.eclipse.scout.rt.server.jaxws.consumer.AbstractWebServiceClient");
                }
                catch (JavaModelException e) {
                    SdkLog.warning((String)"Unable to check if element '{}' is a web service client.", (Object[])new Object[]{element.getFullyQualifiedName(), e});
                    return false;
                }
            }
        };
        for (Set<IType> portTypes : this.m_portTypes.values()) {
            for (IType portType : portTypes) {
                IType serviceImpl = this.getPortTypeChildClass(portType, serviceImplFilter);
                if (!S2eUtils.exists((IJavaElement)serviceImpl)) continue;
                this.m_serviceImplementations.put(portType, serviceImpl);
            }
        }
    }

    protected void loadWebServicesAndPortTypes() throws CoreException {
        if (this.getServicesFromWsdl().isEmpty()) {
            return;
        }
        Set<IType> candidates = this.findAllTypesAnnotatedWith("javax.xml.ws.WebServiceClient");
        if (candidates.isEmpty()) {
            return;
        }
        for (IType candidate : candidates) {
            IAnnotation annotation = S2eUtils.getAnnotation((IAnnotatable)candidate, (String)"javax.xml.ws.WebServiceClient");
            String name = S2eUtils.getAnnotationValueString((IAnnotation)annotation, (String)"name");
            String targetNamespace = S2eUtils.getAnnotationValueString((IAnnotation)annotation, (String)"targetNamespace");
            for (Service info : this.getServicesFromWsdl().getWebServices().keySet()) {
                QName webServiceName = info.getQName();
                if (!Objects.equals(name, webServiceName.getLocalPart()) || !Objects.equals(targetNamespace, webServiceName.getNamespaceURI())) continue;
                this.m_webServices.put(candidate, webServiceName);
                this.loadPortTypes(info, candidate);
            }
        }
    }

    protected void loadPortTypes(Service service, IType webService) throws CoreException {
        if (this.getServicesFromWsdl().isEmpty()) {
            return;
        }
        Set<IType> candidates = this.findAllTypesAnnotatedWith("javax.jws.WebService");
        if (candidates.isEmpty()) {
            return;
        }
        for (IType candidate : candidates) {
            if (!candidate.isInterface()) continue;
            IAnnotation annotation = S2eUtils.getAnnotation((IAnnotatable)candidate, (String)"javax.jws.WebService");
            String name = S2eUtils.getAnnotationValueString((IAnnotation)annotation, (String)"name");
            String targetNamespace = S2eUtils.getAnnotationValueString((IAnnotation)annotation, (String)"targetNamespace");
            for (Map.Entry port : this.getServicesFromWsdl().getPorts(service).entrySet()) {
                QName portTypeName = (QName)port.getValue();
                if (!Objects.equals(name, portTypeName.getLocalPart()) || !Objects.equals(targetNamespace, portTypeName.getNamespaceURI())) continue;
                Set<IType> portTypesForCurrentService = this.m_portTypes.get(webService);
                if (portTypesForCurrentService == null) {
                    portTypesForCurrentService = new LinkedHashSet<IType>(3);
                    this.m_portTypes.put(webService, portTypesForCurrentService);
                }
                portTypesForCurrentService.add(candidate);
                this.m_portTypeNamesInWsdl.put(candidate, portTypeName);
            }
        }
    }

    protected Set<IType> findAllTypesAnnotatedWith(String fqn) throws CoreException {
        IJavaSearchScope scope = S2eUtils.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getJavaProject()});
        return S2eUtils.findAllTypesAnnotatedWith((String)fqn, (IJavaSearchScope)scope, null);
    }

    protected ITypeHierarchy getTypeHierarchy(IType t) throws JavaModelException {
        if (!S2eUtils.exists((IJavaElement)t)) {
            return null;
        }
        ITypeHierarchy hierarchy = this.m_hierarchyCache.get(t);
        if (hierarchy != null) {
            return hierarchy;
        }
        hierarchy = t.newTypeHierarchy(null);
        this.m_hierarchyCache.put(t, hierarchy);
        return hierarchy;
    }

    protected ITypeHierarchy getSuperTypeHierarchy(IType t) throws JavaModelException {
        if (!S2eUtils.exists((IJavaElement)t)) {
            return null;
        }
        ITypeHierarchy hierarchy = this.m_superHierarchyCache.get(t);
        if (hierarchy != null) {
            return hierarchy;
        }
        hierarchy = t.newSupertypeHierarchy(null);
        this.m_superHierarchyCache.put(t, hierarchy);
        return hierarchy;
    }

    protected void loadBindings() throws CoreException {
        Document pomDocument = S2eUtils.getPomDocument((IProject)this.getJavaProject().getProject());
        if (pomDocument == null) {
            return;
        }
        final IFolder bindingFolder = WebServiceNewOperation.getBindingRootFolder((IProject)this.getJavaProject().getProject());
        if (!bindingFolder.exists()) {
            return;
        }
        try {
            IPath wsdlFolderRelativePath = this.getWsdl().getProjectRelativePath().makeRelativeTo(WebServiceNewOperation.getWsdlRootFolder((IProject)this.getWsdl().getProject()).getProjectRelativePath());
            List paths = JaxWsUtils.getBindingPathsFromPom((Document)pomDocument, (String)wsdlFolderRelativePath.toString());
            if (paths.isEmpty()) {
                bindingFolder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.getType() == 1) {
                            WebServiceFormPageInput.this.m_bindings.add((IFile)proxy.requestResource());
                        }
                        return bindingFolder.getName().equals(proxy.getName());
                    }
                }, 0);
            } else {
                for (String bindingRelPath : paths) {
                    IFile candidate = bindingFolder.getFile((IPath)new Path(bindingRelPath));
                    if (!candidate.exists()) continue;
                    this.m_bindings.add(candidate);
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
    }

    protected void loadJaxwsBindingFile() throws CoreException {
        if (this.m_bindings.isEmpty()) {
            return;
        }
        for (IFile candidate : this.m_bindings) {
            String rootNs;
            Document document = S2eUtils.readXmlDocument((IFile)candidate);
            Element rootTag = document.getDocumentElement();
            if (!"bindings".equals(rootTag.getLocalName()) || !"http://java.sun.com/xml/ns/jaxws".equals(rootNs = rootTag.getNamespaceURI())) continue;
            this.m_jaxwsBindingFiles.add(candidate);
        }
    }

    public IType getWebService(IType portType) {
        for (Map.Entry<IType, Set<IType>> entry : this.m_portTypes.entrySet()) {
            for (IType pt : entry.getValue()) {
                if (!pt.equals(portType)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public QName getWebServiceNameInWsdl(IType webService) {
        return this.m_webServices.get(webService);
    }

    public QName getPortTypeNameInWsdl(IType portType) {
        return this.m_portTypeNamesInWsdl.get(portType);
    }

    public List<IFile> getJaxWsBindingFiles() {
        return Collections.unmodifiableList(this.m_jaxwsBindingFiles);
    }

    public boolean hasConsumerElements() {
        return !this.m_webServiceClients.isEmpty();
    }

    public boolean hasProviderElements() {
        return !this.m_entryPoints.isEmpty() || !this.m_serviceImplementations.isEmpty() || !this.m_entryPointDefinitions.isEmpty();
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public IFile getWsdl() {
        return this.m_wsdl;
    }

    public IType getWebServiceClient(IType portType) {
        return this.m_webServiceClients.get(portType);
    }

    public IType getEntryPoint(IType portType) {
        return this.m_entryPoints.get(portType);
    }

    public IType getEntryPointDefinition(IType portType) {
        return this.m_entryPointDefinitions.get(portType);
    }

    public IType getServiceImplementation(IType portType) {
        return this.m_serviceImplementations.get(portType);
    }

    public Set<IType> getPortTypes(IType webService) {
        Set<IType> result = this.m_portTypes.get(webService);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<IType> getAllPortTypes() {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        for (Set<IType> portTypesByService : this.m_portTypes.values()) {
            result.addAll(portTypesByService);
        }
        return result;
    }

    public Set<IType> getWebServices() {
        return Collections.unmodifiableSet(this.m_webServices.keySet());
    }

    protected ParsedWsdl getServicesFromWsdl() {
        return this.m_servicesFromWsdl;
    }

    protected void setServicesFromWsdl(ParsedWsdl namesFromWsdl) {
        this.m_servicesFromWsdl = namesFromWsdl;
    }

    public String getEntryPointNameFromDefinition(IType portType) {
        return this.m_entryPointNameFromDefinitions.get(portType);
    }

    public String getEntryPointPackageFromDefinition(IType portType) {
        return this.m_entryPointPackageFromDefinitions.get(portType);
    }

    public IType getAuthMethodFromDefinition(IType portType) {
        return this.m_authMethodFromDefinitions.get(portType);
    }

    public IType getAuthVerifierFromDefinition(IType portType) {
        return this.m_authVerifierFromDefinitions.get(portType);
    }

    public List<IFile> getBindings() {
        return Collections.unmodifiableList(this.m_bindings);
    }

    public List<IType> getHandlers(IType portType) {
        List<IType> list = this.m_handlersFromDefinitions.get(portType);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public int hashCode() {
        return this.m_hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebServiceFormPageInput other = (WebServiceFormPageInput)obj;
        return this.m_wsdl.equals((Object)other.m_wsdl);
    }

    @Override
    public int compareTo(WebServiceFormPageInput o) {
        if (o.getWsdl() == this.getWsdl()) {
            return 0;
        }
        int result = this.getWsdl().getName().compareTo(o.getWsdl().getName());
        if (result != 0) {
            return result;
        }
        return this.getWsdl().getFullPath().makeAbsolute().toOSString().compareTo(this.getWsdl().getFullPath().makeAbsolute().toOSString());
    }

    public String toString() {
        return this.getWsdl().getFullPath().toString();
    }
}

