/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.project;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.s.project.ScoutProjectNewHelper;
import org.eclipse.scout.sdk.s2e.ui.fields.resource.IResourceChangedListener;
import org.eclipse.scout.sdk.s2e.ui.fields.resource.ResourceTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ScoutProjectNewWizardPage
extends AbstractWizardPage {
    public static final String PROP_GROUP_ID = "groupId";
    public static final String PROP_ARTIFACT_ID = "artifactId";
    public static final String PROP_DISPLAY_NAME = "dispName";
    public static final String PROP_DIR = "dir";
    public static final String PROP_USE_WORKSPACE_LOC = "useWorkspaceLoc";
    public static final String PROP_USE_JS_CLIENT = "useJsClient";
    public static final String SETTINGS_TARGET_DIR = "targetDirSetting";
    protected StyledTextField m_groupIdField;
    protected StyledTextField m_artifactIdField;
    protected StyledTextField m_displayNameField;
    protected Button m_javaScriptButton;
    protected Button m_javaButton;
    protected Button m_useWsLoc;
    protected ResourceTextField m_targetDirectoryField;

    public ScoutProjectNewWizardPage() {
        super(ScoutProjectNewWizardPage.class.getName());
        this.setTitle("Create a Scout Project");
        this.setDescription("Create a new Scout Project");
        this.initDefaultValues();
    }

    @Override
    protected void createContent(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        int labelWidth = 100;
        this.createProjectNameGroup(parent, labelWidth);
        this.createClientLanguageGroup(parent);
        this.createProjectLocationGroup(parent, labelWidth);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_new_project_page_context");
    }

    protected void createProjectNameGroup(Composite parent, int labelWidth) {
        Group nameGroup = this.getFieldToolkit().createGroupBox(parent, "Project Name");
        this.m_groupIdField = this.getFieldToolkit().createStyledTextField((Composite)nameGroup, "Group Id", 1, labelWidth);
        this.m_groupIdField.setText(this.getGroupId());
        this.m_groupIdField.setSelection(new Point(0, this.m_groupIdField.getText().length()));
        this.m_groupIdField.setFocus();
        this.m_groupIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.setGroupIdInternal(ScoutProjectNewWizardPage.this.m_groupIdField.getText());
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_artifactIdField = this.getFieldToolkit().createStyledTextField((Composite)nameGroup, "Artifact Id", 1, labelWidth);
        this.m_artifactIdField.setText(this.getArtifactId());
        this.m_artifactIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.setArtifactIdInternal(ScoutProjectNewWizardPage.this.m_artifactIdField.getText());
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_displayNameField = this.getFieldToolkit().createStyledTextField((Composite)nameGroup, "Display Name", 1, labelWidth);
        this.m_displayNameField.setText(this.getDisplayName());
        this.m_displayNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScoutProjectNewWizardPage.this.setDisplayNameInternal(ScoutProjectNewWizardPage.this.m_displayNameField.getText());
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)nameGroup);
        GridDataFactory.defaultsFor((Control)nameGroup).align(4, 0x1000000).grab(true, false).applyTo((Control)nameGroup);
        GridDataFactory.defaultsFor((Control)this.m_groupIdField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_groupIdField);
        GridDataFactory.defaultsFor((Control)this.m_artifactIdField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_artifactIdField);
        GridDataFactory.defaultsFor((Control)this.m_displayNameField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_displayNameField);
    }

    protected void createClientLanguageGroup(Composite parent) {
        Group uiLangBox = this.getFieldToolkit().createGroupBox(parent, "Programming language of the user interface");
        this.m_javaScriptButton = new Button((Composite)uiLangBox, 16);
        this.m_javaScriptButton.setText("JavaScript && JSON");
        this.m_javaScriptButton.setSelection(this.isUseJsClient());
        this.m_javaScriptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScoutProjectNewWizardPage.this.setUseJsClientInternal(ScoutProjectNewWizardPage.this.m_javaScriptButton.getSelection());
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_javaButton = new Button((Composite)uiLangBox, 16);
        this.m_javaButton.setText("Java");
        this.m_javaButton.setSelection(!this.isUseJsClient());
        this.m_javaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScoutProjectNewWizardPage.this.setUseJsClientInternal(!ScoutProjectNewWizardPage.this.m_javaButton.getSelection());
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)uiLangBox);
        GridDataFactory.defaultsFor((Control)uiLangBox).align(4, 0x1000000).grab(true, false).indent(0, 10).applyTo((Control)uiLangBox);
        GridDataFactory.defaultsFor((Control)this.m_javaScriptButton).indent(13, 5).applyTo((Control)this.m_javaScriptButton);
        GridDataFactory.defaultsFor((Control)this.m_javaButton).indent(13, 2).applyTo((Control)this.m_javaButton);
    }

    protected void createProjectLocationGroup(Composite parent, int labelWidth) {
        Group locationGroup = this.getFieldToolkit().createGroupBox(parent, "Project Location");
        this.createLocationCheckbox((Composite)locationGroup);
        this.m_targetDirectoryField = this.getFieldToolkit().createResourceField((Composite)locationGroup, "Target Directory", 1, labelWidth);
        this.m_targetDirectoryField.setFile(this.getTargetDirectory());
        this.m_targetDirectoryField.setFolderMode(true);
        this.m_targetDirectoryField.setEnabled(!this.m_useWsLoc.getSelection());
        this.m_targetDirectoryField.addResourceChangedListener(new IResourceChangedListener(){

            @Override
            public void resourceChanged(URL newUrl, File newFile) {
                ScoutProjectNewWizardPage.this.setTargetDirectoryInternal(newFile);
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)locationGroup);
        GridDataFactory.defaultsFor((Control)locationGroup).align(4, 0x1000000).grab(true, false).indent(0, 10).applyTo((Control)locationGroup);
        GridDataFactory.defaultsFor((Control)this.m_targetDirectoryField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_targetDirectoryField);
    }

    protected Composite createLocationCheckbox(Composite p) {
        Composite parent = new Composite(p, 0);
        Label lbl = new Label(parent, 0);
        this.m_useWsLoc = this.getFieldToolkit().createCheckBox(parent, "Use default Workspace location", this.isUseWorkspaceLocation());
        this.m_useWsLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScoutProjectNewWizardPage.this.setUseWorkspaceLocationInternal(ScoutProjectNewWizardPage.this.m_useWsLoc.getSelection());
                ScoutProjectNewWizardPage.this.updateTargetDirViewState();
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new FormLayout());
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).applyTo((Control)parent);
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(0, 10);
        labelData.bottom = new FormAttachment(100, 0);
        lbl.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)lbl, 5);
        textData.right = new FormAttachment(100, 0);
        textData.bottom = new FormAttachment(100, 0);
        this.m_useWsLoc.setLayoutData((Object)textData);
        return parent;
    }

    protected void initDefaultValues() {
        this.setGroupIdInternal("org.eclipse.scout.apps");
        this.setArtifactIdInternal("helloworld");
        this.setDisplayNameInternal("My Application");
        this.setUseJsClientInternal(false);
        this.setUseWorkspaceLocationInternal(true);
        this.updateTargetDirViewState();
    }

    protected void updateTargetDirViewState() {
        if (this.isControlCreated()) {
            this.m_targetDirectoryField.setEnabled(!this.isUseWorkspaceLocation());
        }
        File file = null;
        if (this.isUseWorkspaceLocation()) {
            file = ScoutProjectNewWizardPage.getWorkspaceLocation();
        } else {
            File wsLoc = ScoutProjectNewWizardPage.getWorkspaceLocation();
            if (this.getTargetDirectory() == null || wsLoc.equals(this.getTargetDirectory())) {
                String recentTargetDir = this.getDialogSettings().get(SETTINGS_TARGET_DIR);
                file = recentTargetDir != null ? new File(recentTargetDir) : wsLoc;
            }
        }
        if (file != null) {
            this.setTargetDirectory(file);
        }
    }

    public static File getWorkspaceLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsoluteFile();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusGroupId());
        multiStatus.add(this.getStatusArtifactId());
        multiStatus.add(this.getStatusDisplayName());
        multiStatus.add(this.getStatusTargetDirectory());
    }

    protected IStatus getStatusGroupId() {
        String msg = ScoutProjectNewHelper.getMavenGroupIdErrorMessage((String)this.getGroupId());
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusArtifactId() {
        String artifactId = this.getArtifactId();
        String msg = ScoutProjectNewHelper.getMavenArtifactIdErrorMessage((String)artifactId);
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        File folder = null;
        folder = this.isUseWorkspaceLocation() ? ScoutProjectNewWizardPage.getWorkspaceLocation() : this.getTargetDirectory();
        if (folder != null && new File(folder, artifactId).exists()) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "A project with this Artifact Id already exists in this target directory.");
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.getName().startsWith(String.valueOf(artifactId) + '.')) {
                return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "A project with this Artifact Id already exists in the workspace.");
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusDisplayName() {
        String msg = ScoutProjectNewHelper.getDisplayNameErrorMessage((String)this.getDisplayName());
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusTargetDirectory() {
        if (this.isUseWorkspaceLocation()) {
            return Status.OK_STATUS;
        }
        if (this.getTargetDirectory() == null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "Please choose a target directory.");
        }
        return Status.OK_STATUS;
    }

    public String getDisplayName() {
        return this.getPropertyString(PROP_DISPLAY_NAME);
    }

    public void setDisplayName(String s) {
        try {
            this.setStateChanging(true);
            this.setDisplayNameInternal(s);
            if (this.isControlCreated()) {
                this.m_displayNameField.setText(s);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setDisplayNameInternal(String s) {
        this.setPropertyString(PROP_DISPLAY_NAME, s);
    }

    public String getGroupId() {
        return this.getPropertyString(PROP_GROUP_ID);
    }

    public void setGroupId(String s) {
        try {
            this.setStateChanging(true);
            this.setGroupIdInternal(s);
            if (this.isControlCreated()) {
                this.m_groupIdField.setText(s);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setGroupIdInternal(String s) {
        this.setPropertyString(PROP_GROUP_ID, s);
    }

    public String getArtifactId() {
        return this.getPropertyString(PROP_ARTIFACT_ID);
    }

    public void setArtifactId(String s) {
        try {
            this.setStateChanging(true);
            this.setArtifactIdInternal(s);
            if (this.isControlCreated()) {
                this.m_artifactIdField.setText(s);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setArtifactIdInternal(String s) {
        this.setPropertyString(PROP_ARTIFACT_ID, s);
    }

    public boolean isUseWorkspaceLocation() {
        return this.getPropertyBool(PROP_USE_WORKSPACE_LOC);
    }

    public void setUseWorkspaceLocation(boolean f) {
        try {
            this.setStateChanging(true);
            this.setUseWorkspaceLocationInternal(f);
            if (this.isControlCreated()) {
                this.m_useWsLoc.setSelection(f);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setUseWorkspaceLocationInternal(boolean f) {
        this.setPropertyBool(PROP_USE_WORKSPACE_LOC, f);
    }

    public File getTargetDirectory() {
        return this.getProperty(PROP_DIR, File.class);
    }

    public void setTargetDirectory(File f) {
        try {
            this.setStateChanging(true);
            this.setTargetDirectoryInternal(f);
            if (this.isControlCreated()) {
                this.m_targetDirectoryField.setFile(f);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetDirectoryInternal(File f) {
        this.setProperty(PROP_DIR, f);
    }

    public boolean isUseJsClient() {
        return this.getPropertyBool(PROP_USE_JS_CLIENT);
    }

    public void setUseJsClient(boolean isUseJsClient) {
        try {
            this.setStateChanging(true);
            this.setUseJsClientInternal(isUseJsClient);
            if (this.isControlCreated()) {
                this.m_javaButton.setSelection(!isUseJsClient);
                this.m_javaScriptButton.setSelection(isUseJsClient);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setUseJsClientInternal(boolean isUseJsClient) {
        this.setPropertyBool(PROP_USE_JS_CLIENT, isUseJsClient);
    }
}

