/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.service;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.sourcebuilder.service.ServiceImplSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.service.ServiceInterfaceSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.AnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;

public class ServiceNewOperation
implements IOperation {
    private final IJavaEnvironmentProvider m_javaEnvironmentProvider;
    private ITypeSourceBuilder m_serviceIfcBuilder;
    private IPackageFragmentRoot m_sharedSourceFolder;
    private IPackageFragmentRoot m_serverSourceFolder;
    private String m_sharedPackage;
    private String m_serviceName;
    private final List<IMethodSourceBuilder> m_methods;
    private IType m_createdServiceInterface;
    private IType m_createdServiceImpl;

    public ServiceNewOperation() {
        this(new CachingJavaEnvironmentProvider());
    }

    public ServiceNewOperation(IJavaEnvironmentProvider provider) {
        this.m_javaEnvironmentProvider = (IJavaEnvironmentProvider)Validate.notNull((Object)provider);
        this.m_methods = new LinkedList<IMethodSourceBuilder>();
    }

    @Override
    public String getOperationName() {
        return "Create Service '" + this.getServiceName() + "'.";
    }

    @Override
    public void validate() {
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSharedSourceFolder()), (String)"No shared source folder provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getServerSourceFolder()), (String)"No server source folder provided", (Object[])new Object[0]);
        Validate.notNull((Object)this.getSharedPackage(), (String)"No shared package provided", (Object[])new Object[0]);
        Validate.notNull((Object)this.getServiceName(), (String)"No service base name provided", (Object[])new Object[0]);
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)2);
        String serverPackage = ScoutTier.Shared.convert(ScoutTier.Server, this.getSharedPackage());
        String svcName = String.valueOf(this.getServiceName()) + "Service";
        this.setCreatedServiceInterface(this.createServiceIfc(svcName, this.getSharedPackage(), (IProgressMonitor)progress.newChild(1), workingCopyManager));
        this.setCreatedServiceImpl(this.createServiceImpl(svcName, serverPackage, (IProgressMonitor)progress.newChild(1), workingCopyManager));
    }

    protected ServiceImplSourceBuilder createServiceImplBuilder(String svcName, String serverPackage) throws JavaModelException {
        IType existingServiceImpl = this.getServerSourceFolder().getJavaProject().findType(serverPackage, svcName);
        ServiceImplSourceBuilder implBuilder = null;
        ICompilationUnit compilationUnit = null;
        IJavaEnvironment env = this.getEnvProvider().get(this.getServerSourceFolder().getJavaProject());
        if (S2eUtils.exists((IJavaElement)existingServiceImpl) && !existingServiceImpl.isBinary()) {
            compilationUnit = S2eUtils.jdtTypeToScoutType(existingServiceImpl, env).compilationUnit();
            implBuilder = new ServiceImplSourceBuilder(compilationUnit, this.getServiceIfcBuilder());
        } else {
            implBuilder = new ServiceImplSourceBuilder(svcName, serverPackage, env, this.getServiceIfcBuilder());
        }
        implBuilder.setup();
        for (IMethodSourceBuilder msb : this.getMethods()) {
            if (compilationUnit != null && compilationUnit.mainType().methods().withMethodIdentifier(msb.getMethodIdentifier()).existsAny()) continue;
            boolean existsInInterface = Flags.isInterface((int)msb.getFlags()) || Flags.isPublic((int)msb.getFlags());
            msb.setFlags(msb.getFlags() & 0xFFFFFDFF | 1);
            msb.setComment(null);
            if (existsInInterface) {
                msb.addAnnotation(AnnotationSourceBuilderFactory.createOverride());
            }
            implBuilder.getMainType().addMethod(msb);
        }
        return implBuilder;
    }

    protected IType createServiceImpl(String svcName, String serverPackage, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws JavaModelException {
        ServiceImplSourceBuilder implBuilder = this.createServiceImplBuilder(svcName, serverPackage);
        return S2eUtils.writeType(this.getServerSourceFolder(), (ICompilationUnitSourceBuilder)implBuilder, this.getEnvProvider().get(this.getServerSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    protected ServiceInterfaceSourceBuilder createServiceIfcBuilder(String svcName, String sharedPackage) throws JavaModelException {
        String ifcName = String.valueOf('I') + svcName;
        IType existingServiceIfc = this.getSharedSourceFolder().getJavaProject().findType(sharedPackage, ifcName);
        ServiceInterfaceSourceBuilder ifcBuilder = null;
        ICompilationUnit compilationUnit = null;
        IJavaEnvironment env = this.getEnvProvider().get(this.getSharedSourceFolder().getJavaProject());
        if (S2eUtils.exists((IJavaElement)existingServiceIfc) && !existingServiceIfc.isBinary()) {
            compilationUnit = S2eUtils.jdtTypeToScoutType(existingServiceIfc, env).compilationUnit();
            ifcBuilder = new ServiceInterfaceSourceBuilder(compilationUnit);
        } else {
            ifcBuilder = new ServiceInterfaceSourceBuilder(ifcName, sharedPackage, env);
        }
        ifcBuilder.setup();
        for (IMethodSourceBuilder msb : this.getMethods()) {
            if (!Flags.isPublic((int)msb.getFlags()) && !Flags.isInterface((int)msb.getFlags()) || compilationUnit != null && compilationUnit.mainType().methods().withMethodIdentifier(msb.getMethodIdentifier()).existsAny()) continue;
            msb.setFlags((msb.getFlags() | 0x200) & 0xFFFFFFFE);
            ifcBuilder.getMainType().addMethod(msb);
        }
        return ifcBuilder;
    }

    protected IType createServiceIfc(String svcName, String sharedPackage, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws JavaModelException {
        ServiceInterfaceSourceBuilder ifcBuilder = this.createServiceIfcBuilder(svcName, sharedPackage);
        IType createdIfc = S2eUtils.writeType(this.getSharedSourceFolder(), (ICompilationUnitSourceBuilder)ifcBuilder, this.getEnvProvider().get(this.getSharedSourceFolder().getJavaProject()), monitor, workingCopyManager);
        this.setServiceIfcBuilder(ifcBuilder.getMainType());
        return createdIfc;
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    protected IJavaEnvironmentProvider getEnvProvider() {
        return this.m_javaEnvironmentProvider;
    }

    protected ITypeSourceBuilder getServiceIfcBuilder() {
        return this.m_serviceIfcBuilder;
    }

    protected void setServiceIfcBuilder(ITypeSourceBuilder serviceIfcBuilder) {
        this.m_serviceIfcBuilder = serviceIfcBuilder;
    }

    public IType getCreatedServiceInterface() {
        return this.m_createdServiceInterface;
    }

    protected void setCreatedServiceInterface(IType createdServiceInterface) {
        this.m_createdServiceInterface = createdServiceInterface;
    }

    public IType getCreatedServiceImpl() {
        return this.m_createdServiceImpl;
    }

    protected void setCreatedServiceImpl(IType createdServiceImpl) {
        this.m_createdServiceImpl = createdServiceImpl;
    }

    public String getSharedPackage() {
        return this.m_sharedPackage;
    }

    public void setSharedPackage(String sharedPackage) {
        this.m_sharedPackage = sharedPackage;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void addMethod(IMethodSourceBuilder msb) {
        this.m_methods.add(msb);
    }

    public List<IMethodSourceBuilder> getMethods() {
        return this.m_methods;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }
}

