/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.EndOfLifeEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.InstanceRoleEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.LifelineNodeFigure;

public class SequenceMessagesRouter
extends AbstractRouter
implements ConnectionRouter {
    private static final PrecisionPoint A_POINT = new PrecisionPoint();
    private Map<Connection, Object> constraints = new WeakHashMap<Connection, Object>();

    public void setConstraint(Connection connection, Object constraint) {
        this.constraints.put(connection, constraint);
    }

    public Object getConstraint(Connection connection) {
        return this.constraints.get(connection);
    }

    public void remove(Connection connection) {
        this.constraints.remove(connection);
    }

    public void route(Connection conn) {
        if (!this.isValidConnection(conn)) {
            return;
        }
        List<Bendpoint> bendpoints = this.getRefreshedConstraint(conn);
        IGraphicalEditPart part = null;
        if (conn instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            part = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)conn).getEditPart();
        }
        Point sourceRef = this.getReferencePoint(conn, true, bendpoints);
        Point targetRef = this.getReferencePoint(conn, false, bendpoints);
        boolean leftToRight = conn.getSourceAnchor().getReferencePoint().x < conn.getTargetAnchor().getReferencePoint().x;
        boolean msgToSelf = sourceRef.x == targetRef.x && sourceRef.y != targetRef.y || bendpoints.size() >= 4;
        msgToSelf = msgToSelf || this.isReflectiveMessage(part);
        Rectangle sourceOwnerBounds = this.getAnchorOwnerBounds(conn.getSourceAnchor());
        Rectangle targetOwnerBounds = this.getAnchorOwnerBounds(conn.getTargetAnchor());
        sourceRef.x = this.getRefX(true, leftToRight, msgToSelf, sourceOwnerBounds, conn.getSourceAnchor().getOwner());
        targetRef.x = this.getRefX(false, leftToRight, msgToSelf, targetOwnerBounds, conn.getTargetAnchor().getOwner());
        PointList points = new PointList(Math.max(2, bendpoints.size()));
        if (msgToSelf) {
            Message msg;
            Point secondPoint = sourceRef.getCopy();
            Point thirdPoint = targetRef.getCopy();
            double zoom = part == null ? 1.0 : GraphicalHelper.getZoom((EditPart)part);
            int hGap = 30;
            if (part instanceof SequenceMessageEditPart && (msg = (Message)((SequenceMessageEditPart)part).getISequenceEvent()).isReflective()) {
                hGap = msg.getReflexiveMessageWidth();
            }
            thirdPoint.x = secondPoint.x = Math.max(sourceRef.x, targetRef.x) + (int)((double)hGap * zoom);
            conn.translateToRelative((Translatable)sourceRef);
            conn.translateToRelative((Translatable)secondPoint);
            conn.translateToRelative((Translatable)thirdPoint);
            points.addPoint(sourceRef);
            points.addPoint(secondPoint);
            points.addPoint(thirdPoint);
        } else {
            conn.translateToRelative((Translatable)sourceRef);
            points.addPoint(sourceRef);
        }
        conn.translateToRelative((Translatable)targetRef);
        points.addPoint(targetRef);
        conn.setPoints(points);
    }

    private int getRefX(boolean source, boolean leftToRight, boolean msgToSelf, Rectangle anchorOwnerBounds, IFigure anchorOwner) {
        int refX;
        boolean onLeft = source && !leftToRight || leftToRight && !source;
        boolean bl = onLeft = onLeft && !msgToSelf;
        if (msgToSelf) {
            refX = anchorOwnerBounds.getRight().x;
        } else {
            int n = refX = onLeft ? anchorOwnerBounds.getLeft().x : anchorOwnerBounds.getRight().x;
        }
        if (anchorOwner instanceof LifelineNodeFigure) {
            LifelineNodeFigure lnf = (LifelineNodeFigure)anchorOwner;
            int refMidWidth = (anchorOwnerBounds.width - lnf.getLineWidth()) / 2;
            refX += onLeft ? refMidWidth : -refMidWidth;
        }
        return refX;
    }

    private Point getReferencePoint(Connection conn, boolean source, List<Bendpoint> bendpoints) {
        Point ref;
        if (bendpoints.isEmpty()) {
            ConnectionAnchor anchor = source ? conn.getSourceAnchor() : conn.getTargetAnchor();
            ref = anchor.getReferencePoint().getCopy();
        } else {
            int index = source ? 0 : bendpoints.size() - 1;
            ref = new Point(bendpoints.get(index).getLocation());
            conn.translateToAbsolute((Translatable)ref);
        }
        return ref;
    }

    private Rectangle getAnchorOwnerBounds(ConnectionAnchor anchor) {
        Rectangle ownerBounds = anchor.getOwner().getBounds().getCopy();
        anchor.getOwner().getParent().translateToAbsolute((Translatable)ownerBounds);
        return ownerBounds;
    }

    private boolean isReflectiveMessage(IGraphicalEditPart part) {
        if (part instanceof SequenceMessageEditPart) {
            ISequenceEvent ise = ((SequenceMessageEditPart)part).getISequenceEvent();
            return ise instanceof Message && ((Message)ise).isReflective();
        }
        return false;
    }

    private List<Bendpoint> getRefreshedConstraint(Connection conn) {
        boolean noBendpointsAtbeginning = false;
        List<Bendpoint> bendpoints = (List<Bendpoint>)this.getConstraint(conn);
        if (bendpoints == null) {
            noBendpointsAtbeginning = true;
            bendpoints = Collections.emptyList();
        }
        this.refreshBendpoints(bendpoints, conn);
        if (!noBendpointsAtbeginning || !Collections.emptyList().equals(bendpoints)) {
            this.setConstraint(conn, bendpoints);
        }
        return bendpoints;
    }

    private boolean isValidConnection(Connection conn) {
        return this.isValidAnchor(conn.getSourceAnchor()) && this.isValidAnchor(conn.getTargetAnchor());
    }

    private boolean isValidAnchor(ConnectionAnchor anchor) {
        return anchor != null && anchor.getOwner() != null;
    }

    private void refreshBendpoints(List<Bendpoint> bendpoints, Connection conn) {
        IGraphicalEditPart part = null;
        if (conn instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            part = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)conn).getEditPart();
        }
        if (bendpoints.size() > 2) {
            if (this.isReflectiveMessage(part)) {
                if (bendpoints.size() > 4) {
                    this.align5BendpointsOfMessageToSelf(bendpoints, conn);
                } else if (bendpoints.size() == 4) {
                    this.align4BendpointsOfMessageToSelf(bendpoints, conn);
                }
            } else {
                Bendpoint start = bendpoints.get(0);
                Bendpoint end = bendpoints.get(bendpoints.size() - 1);
                Bendpoint moveRef = bendpoints.get(1);
                bendpoints.clear();
                A_POINT.setLocation(start.getLocation());
                SequenceMessagesRouter.A_POINT.y = moveRef.getLocation().y;
                AbsoluteBendpoint newStart = new AbsoluteBendpoint((Point)A_POINT);
                bendpoints.add((Bendpoint)newStart);
                bendpoints.add(moveRef);
                A_POINT.setLocation(end.getLocation());
                SequenceMessagesRouter.A_POINT.y = moveRef.getLocation().y;
                AbsoluteBendpoint newEnd = new AbsoluteBendpoint((Point)A_POINT);
                bendpoints.add((Bendpoint)newEnd);
            }
        } else if (bendpoints.size() == 2) {
            Bendpoint start = bendpoints.get(0);
            Bendpoint end = bendpoints.get(bendpoints.size() - 1);
            bendpoints.clear();
            AbsoluteBendpoint newStart = new AbsoluteBendpoint(start.getLocation());
            AbsoluteBendpoint newEnd = new AbsoluteBendpoint(end.getLocation());
            if (this.isReflectiveMessage(part)) {
                bendpoints.addAll(this.createMessageToSelf(start, end, (SequenceMessageEditPart)part));
            } else {
                if (part instanceof SequenceMessageEditPart && (((SequenceMessageEditPart)part).getTarget() instanceof InstanceRoleEditPart || ((SequenceMessageEditPart)part).getTarget() instanceof EndOfLifeEditPart)) {
                    int yCenterPosition;
                    IGraphicalEditPart target = (IGraphicalEditPart)((SequenceMessageEditPart)part).getTarget();
                    Rectangle targetBounds = target.getFigure().getBounds();
                    newStart.getLocation().y = yCenterPosition = targetBounds.y + targetBounds.height / 2;
                }
                bendpoints.add((Bendpoint)newStart);
                newEnd.getLocation().y = newStart.getLocation().y;
                bendpoints.add((Bendpoint)newEnd);
            }
        }
    }

    private void align4BendpointsOfMessageToSelf(List<Bendpoint> bendpoints, Connection conn) {
        AbsoluteBendpoint oldThirdPoint;
        AbsoluteBendpoint oldSecondPoint;
        AbsoluteBendpoint newStart = new AbsoluteBendpoint(bendpoints.get(0).getLocation());
        AbsoluteBendpoint newSecondPoint = new AbsoluteBendpoint(bendpoints.get(1).getLocation());
        AbsoluteBendpoint newThirdPoint = new AbsoluteBendpoint(bendpoints.get(2).getLocation());
        AbsoluteBendpoint newEnd = new AbsoluteBendpoint(bendpoints.get(3).getLocation());
        bendpoints.clear();
        if (conn.getPoints() != null && conn.getPoints().size() == 4) {
            oldSecondPoint = new AbsoluteBendpoint(conn.getPoints().getPoint(1));
            oldThirdPoint = new AbsoluteBendpoint(conn.getPoints().getPoint(2));
        } else {
            oldSecondPoint = newSecondPoint;
            oldThirdPoint = newThirdPoint;
        }
        if (oldSecondPoint.getLocation().y != newSecondPoint.getLocation().y) {
            if (newSecondPoint.getLocation().y > newThirdPoint.getLocation().y - 10) {
                newSecondPoint.getLocation().y = newThirdPoint.getLocation().y - 10;
            }
            newStart.getLocation().y = newSecondPoint.getLocation().y;
        }
        if (oldThirdPoint.getLocation().y != newThirdPoint.getLocation().y) {
            if (newThirdPoint.getLocation().y < newSecondPoint.getLocation().y + 10) {
                newThirdPoint.getLocation().y = newSecondPoint.getLocation().y + 10;
            }
            newEnd.getLocation().y = newThirdPoint.getLocation().y;
        }
        bendpoints.add((Bendpoint)newStart);
        bendpoints.add((Bendpoint)newSecondPoint);
        bendpoints.add((Bendpoint)newThirdPoint);
        bendpoints.add((Bendpoint)newEnd);
    }

    private void align5BendpointsOfMessageToSelf(List<Bendpoint> bendpoints, Connection conn) {
        AbsoluteBendpoint newStart = new AbsoluteBendpoint(bendpoints.get(0).getLocation());
        AbsoluteBendpoint secondPoint = new AbsoluteBendpoint(bendpoints.get(1).getLocation());
        AbsoluteBendpoint thirdPoint = new AbsoluteBendpoint(bendpoints.get(2).getLocation());
        AbsoluteBendpoint fourthPoint = new AbsoluteBendpoint(bendpoints.get(3).getLocation());
        AbsoluteBendpoint newEnd = new AbsoluteBendpoint(bendpoints.get(4).getLocation());
        bendpoints.clear();
        AbsoluteBendpoint oldSecondPoint = new AbsoluteBendpoint(conn.getPoints().getPoint(1));
        AbsoluteBendpoint oldThirdPoint = new AbsoluteBendpoint(conn.getPoints().getPoint(2));
        if (oldSecondPoint.getLocation().y != secondPoint.getLocation().y) {
            if (secondPoint.getLocation().y > oldThirdPoint.getLocation().y - 10) {
                secondPoint.getLocation().y = oldThirdPoint.getLocation().y - 10;
            }
            newStart.getLocation().y = secondPoint.getLocation().y;
            thirdPoint.getLocation().y = secondPoint.getLocation().y;
        } else if (oldThirdPoint.getLocation().y != fourthPoint.getLocation().y) {
            if (fourthPoint.getLocation().y < oldSecondPoint.getLocation().y + 10) {
                fourthPoint.getLocation().y = oldSecondPoint.getLocation().y + 10;
            }
            thirdPoint.getLocation().y = fourthPoint.getLocation().y;
            newEnd.getLocation().y = fourthPoint.getLocation().y;
        }
        bendpoints.add((Bendpoint)newStart);
        bendpoints.add((Bendpoint)secondPoint);
        bendpoints.add((Bendpoint)thirdPoint);
        bendpoints.add((Bendpoint)fourthPoint);
        bendpoints.add((Bendpoint)newEnd);
    }

    private List<Bendpoint> createMessageToSelf(Bendpoint start, Bendpoint end, SequenceMessageEditPart part) {
        ArrayList<Bendpoint> messageToSelfBendpoint = new ArrayList<Bendpoint>();
        AbsoluteBendpoint newStart = new AbsoluteBendpoint(start.getLocation());
        AbsoluteBendpoint newSecondPoint = new AbsoluteBendpoint(start.getLocation());
        AbsoluteBendpoint newThirdPoint = new AbsoluteBendpoint(end.getLocation());
        AbsoluteBendpoint newEnd = new AbsoluteBendpoint(end.getLocation());
        int minGap = 10;
        if (newEnd.getLocation().y - newStart.getLocation().y < minGap) {
            newEnd.getLocation().y = newThirdPoint.getLocation().y = newStart.getLocation().y + minGap;
        }
        messageToSelfBendpoint.add((Bendpoint)newStart);
        messageToSelfBendpoint.add((Bendpoint)newSecondPoint);
        messageToSelfBendpoint.add((Bendpoint)newThirdPoint);
        messageToSelfBendpoint.add((Bendpoint)newEnd);
        return messageToSelfBendpoint;
    }
}

