/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.DAnnotation;

public class DRepresentationQuery {
    private DRepresentation representation;
    private Session session;

    public DRepresentationQuery(DRepresentation representation) {
        this.representation = representation;
    }

    public DRepresentationQuery(DRepresentation representation, Session session) {
        this.representation = representation;
        this.session = session;
    }

    public Option<AnnotationEntry> getAnnotation(String source, EObject eObject) {
        for (AnnotationEntry annotation : this.representation.getOwnedAnnotationEntries()) {
            if (!source.equals(annotation.getSource()) || !eObject.equals(annotation.getData())) continue;
            return Options.newSome((Object)annotation);
        }
        return Options.newNone();
    }

    public Collection<AnnotationEntry> getAnnotation(String source) {
        ArrayList<AnnotationEntry> annotationEntries = new ArrayList<AnnotationEntry>();
        for (AnnotationEntry annotation : this.representation.getOwnedAnnotationEntries()) {
            if (!source.equals(annotation.getSource())) continue;
            annotationEntries.add(annotation);
        }
        return annotationEntries;
    }

    public Option<DAnnotation> getDAnnotation(String source, String detail) {
        DAnnotation annotation = this.representation.getDAnnotation(source);
        if (annotation != null && annotation.getDetails().get((Object)detail) != null) {
            return Options.newSome((Object)annotation);
        }
        return Options.newNone();
    }

    public boolean isDanglingRepresentation() {
        if (this.representation instanceof DSemanticDecorator) {
            DSemanticDecorator semDecRep = (DSemanticDecorator)((Object)this.representation);
            if (this.session == null) {
                this.session = SessionManager.INSTANCE.getSession(semDecRep.getTarget());
            }
            return semDecRep.getTarget() == null || this.session == null;
        }
        return false;
    }

    public DRepresentationDescriptor getRepresentationDescriptor() {
        if (this.representation instanceof DSemanticDecorator) {
            if (this.session == null) {
                this.session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)((Object)this.representation)).getTarget());
            }
            if (this.session != null) {
                Collection usages = this.session.getSemanticCrossReferencer().getInverseReferences((EObject)this.representation);
                for (EStructuralFeature.Setting setting : usages) {
                    if (!ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR.isInstance((Object)setting.getEObject()) || setting.getEStructuralFeature() != ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__REPRESENTATION) continue;
                    return (DRepresentationDescriptor)setting.getEObject();
                }
            }
        }
        return null;
    }
}

