/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ImageCache {
    private static final String DebugUI = "DebugUI:";
    public static final String IMG_TCF = "icons/tcf";
    public static final String IMG_TARGET_TAB = "icons/target_tab";
    public static final String IMG_DOWNLOAD_TAB = "icons/download_tab";
    public static final String IMG_TARGET_WIZARD = "icons/full/wizban/debug_wiz";
    public static final String IMG_APPLICATION_TAB = "icons/application_tab";
    public static final String IMG_ARGUMENTS_TAB = "icons/arguments_tab";
    public static final String IMG_ATTRIBUTE = "icons/attribute";
    public static final String IMG_PATH = "icons/path";
    public static final String IMG_THREAD_TERMINATED = "icons/full/obj16/threadt_obj";
    public static final String IMG_THREAD_SUSPENDED = "icons/full/obj16/threads_obj";
    public static final String IMG_THREAD_RUNNNIG = "icons/full/obj16/thread_obj";
    public static final String IMG_THREAD_REVERSING = "icons/thread_reversing";
    public static final String IMG_THREAD_NOT_ACTIVE = "icons/thread_not_active";
    public static final String IMG_THREAD_UNKNOWN_STATE = "icons/thread_not_active";
    public static final String IMG_PROCESS_TERMINATED = "icons/full/obj16/debugtt_obj";
    public static final String IMG_PROCESS_SUSPENDED = "icons/full/obj16/debugts_obj";
    public static final String IMG_PROCESS_RUNNING = "icons/full/obj16/debugt_obj";
    public static final String IMG_REGISTER = "icons/full/obj16/genericregister_obj";
    public static final String IMG_VARIABLE = "icons/var_simple";
    public static final String IMG_VARIABLE_POINTER = "icons/var_pointer";
    public static final String IMG_VARIABLE_AGGREGATE = "icons/var_aggr";
    public static final String IMG_NEW_EXPRESSION = "icons/full/elcl16/monitorexpression_tsk";
    public static final String IMG_SIGNALS = "icons/signals";
    public static final String IMG_MEMORY_MAP = "icons/memory-map";
    public static final String IMG_PROFILER = "icons/profiler";
    public static final String IMG_ARRAY_PARTITION = "icons/full/obj16/arraypartition_obj";
    public static final String IMG_STACK_FRAME_SUSPENDED = "icons/full/obj16/stckframe_obj";
    public static final String IMG_STACK_FRAME_RUNNING = "icons/full/obj16/stckframe_running_obj";
    public static final String IMG_STACK_FRAME_REVERSING = "icons/stckframe_reversing";
    public static final String IMG_BREAKPOINT_ENABLED = "icons/full/obj16/brkp_obj";
    public static final String IMG_BREAKPOINT_DISABLED = "icons/full/obj16/brkpd_obj";
    public static final String IMG_BREAKPOINT_INSTALLED = "icons/ovr16/installed_ovr";
    public static final String IMG_BREAKPOINT_CONDITIONAL = "icons/ovr16/conditional_ovr";
    public static final String IMG_BREAKPOINT_MOVED = "icons/moved_ovr";
    public static final String IMG_BREAKPOINT_WARNING = "icons/ovr16/warning_ovr";
    public static final String IMG_BREAKPOINT_ERROR = "icons/ovr16/error_ovr";
    public static final String IMG_BREAKPOINT_OVERLAY = "icons/brkp_ovr";
    public static final String IMG_FOLDER = "icons/full/obj16/fldr_obj";
    public static final String IMG_FILE = "icons/full/obj16/file_obj";
    public static final String IMG_INSTRUCTION_POINTER_TOP = "DebugUI:IMG_OBJS_INSTRUCTION_POINTER_TOP";
    public static final String IMG_INSTRUCTION_POINTER = "DebugUI:IMG_OBJS_INSTRUCTION_POINTER";
    private static final Map<String, ImageDescriptor> desc_cache = new HashMap<String, ImageDescriptor>();
    private static final Map<ImageDescriptor, Image> image_cache = new HashMap<ImageDescriptor, Image>();
    private static final Map<String, Map<ImageDescriptor, ImageDescriptor>> overlay_cache = new HashMap<String, Map<ImageDescriptor, ImageDescriptor>>();

    public static synchronized ImageDescriptor getImageDescriptor(String name) {
        if (name == null) {
            return null;
        }
        ImageDescriptor descriptor = desc_cache.get(name);
        if (descriptor == null) {
            if (name.startsWith(DebugUI)) {
                descriptor = DebugUITools.getImageDescriptor((String)name.substring(DebugUI.length()));
            } else {
                String[] ext;
                String[] stringArray = ext = new String[]{"png", "gif"};
                int n = ext.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url;
                    String e = stringArray[n2];
                    IPath path = new Path(name).removeFileExtension().addFileExtension(e);
                    Bundle bundle = Platform.getBundle((String)"org.eclipse.tcf.debug.ui");
                    if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)path, null)) != null && (descriptor = ImageDescriptor.createFromURL((URL)url)) != null || (bundle = Platform.getBundle((String)"org.eclipse.debug.ui")) != null && (url = FileLocator.find((Bundle)bundle, (IPath)path, null)) != null && (descriptor = ImageDescriptor.createFromURL((URL)url)) != null || (bundle = Platform.getBundle((String)"org.eclipse.cdt.debug.ui")) != null && (url = FileLocator.find((Bundle)bundle, (IPath)path, null)) != null && (descriptor = ImageDescriptor.createFromURL((URL)url)) != null) break;
                    ++n2;
                }
                if (descriptor == null) {
                    descriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(name);
                }
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            desc_cache.put(name, descriptor);
        }
        return descriptor;
    }

    public static synchronized ImageDescriptor addOverlay(ImageDescriptor descriptor, String name) {
        return ImageCache.addOverlay(descriptor, name, 0, 0);
    }

    public static synchronized ImageDescriptor addOverlay(ImageDescriptor descriptor, String name, final int x, final int y) {
        Object res;
        if (descriptor == null || name == null) {
            return descriptor;
        }
        String key = String.valueOf(name) + ':' + x + ':' + y;
        Map<ImageDescriptor, ImageDescriptor> map = overlay_cache.get(key);
        if (map == null) {
            map = new HashMap<ImageDescriptor, ImageDescriptor>();
            overlay_cache.put(key, map);
        }
        if ((res = map.get(descriptor)) != null) {
            return res;
        }
        final ImageData base = descriptor.getImageData();
        final ImageData overlay = ImageCache.getImageDescriptor(name).getImageData();
        res = new CompositeImageDescriptor(){

            protected void drawCompositeImage(int width, int height) {
                this.drawImage(base, 0, 0);
                this.drawImage(overlay, x, y);
            }

            protected Point getSize() {
                return new Point(base.width, base.height);
            }
        };
        map.put(descriptor, (ImageDescriptor)res);
        return res;
    }

    public static synchronized Image getImage(ImageDescriptor desc) {
        Image image = image_cache.get(desc);
        if (image == null) {
            image = desc.createImage();
            image_cache.put(desc, image);
        }
        return image;
    }

    public static synchronized Image getImage(String name) {
        return ImageCache.getImage(ImageCache.getImageDescriptor(name));
    }
}

