/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.bindings.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.launch.core.bindings.interfaces.ILaunchBinding;
import org.eclipse.tcf.te.launch.core.bindings.interfaces.IOverwritableLaunchBinding;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.osgi.framework.Bundle;

public class LaunchConfigTypeBinding {
    private final String typeId;
    private final List<ILaunchBinding> lmDelegateBindings = new ArrayList<ILaunchBinding>();
    private final List<ILaunchBinding> stepGroupBindings = new ArrayList<ILaunchBinding>();
    private final List<Expression> expressions = new ArrayList<Expression>();

    public LaunchConfigTypeBinding(String typeId) {
        Assert.isNotNull((Object)typeId);
        this.typeId = typeId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getLaunchManagerDelegate(String mode) {
        Assert.isNotNull((Object)mode);
        ILaunchBinding binding = this.getBinding(this.lmDelegateBindings, mode);
        return binding != null ? binding.getId() : null;
    }

    public void addLaunchManagerDelegate(IOverwritableLaunchBinding binding) {
        Assert.isNotNull((Object)binding);
        if (!this.lmDelegateBindings.contains(binding)) {
            this.lmDelegateBindings.add(binding);
        }
    }

    public String getStepGroupId(String mode) {
        ILaunchBinding binding = this.getBinding(this.stepGroupBindings, mode);
        return binding != null ? binding.getId() : null;
    }

    public void addStepGroup(ILaunchBinding binding) {
        Assert.isNotNull((Object)binding);
        if (!this.stepGroupBindings.contains(binding)) {
            this.stepGroupBindings.add(binding);
        }
    }

    public void addEnablement(Expression expression) {
        Assert.isNotNull((Object)expression);
        if (!this.expressions.contains(expression)) {
            this.expressions.add(expression);
        }
    }

    public EvaluationResult validate(ILaunchSelection selection) {
        Assert.isNotNull((Object)selection);
        EvaluationResult result = EvaluationResult.NOT_LOADED;
        ISelectionContext[] iSelectionContextArray = selection.getSelectedContexts();
        int n = iSelectionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISelectionContext context = iSelectionContextArray[n2];
            if (context.isPreferredContext()) {
                EvaluationResult valresult = this.validate(selection.getLaunchMode(), context);
                if (valresult == EvaluationResult.FALSE) {
                    return EvaluationResult.FALSE;
                }
                if (valresult != EvaluationResult.NOT_LOADED) {
                    result = valresult;
                }
            }
            ++n2;
        }
        return result;
    }

    public EvaluationResult validate(String mode, ISelectionContext context) {
        EvaluationResult result;
        EvaluationResult evaluationResult = result = context.isPreferredContext() ? EvaluationResult.FALSE : EvaluationResult.NOT_LOADED;
        if (this.expressions.isEmpty()) {
            return EvaluationResult.TRUE;
        }
        for (Expression expression : this.expressions) {
            EvaluationResult valresult;
            block5: {
                EvaluationContext evalContext = new EvaluationContext(null, (Object)context);
                evalContext.addVariable("context", context.getContext());
                evalContext.addVariable("selection", (Object)(context.getSelections() != null ? Arrays.asList(context.getSelections()) : Collections.EMPTY_LIST));
                evalContext.addVariable("type", (Object)(context.getType() != null ? context.getType() : ""));
                evalContext.addVariable("mode", (Object)(mode != null ? mode : ""));
                evalContext.setAllowPluginActivation(true);
                try {
                    valresult = expression.evaluate((IEvaluationContext)evalContext);
                }
                catch (CoreException e) {
                    valresult = EvaluationResult.FALSE;
                    if (!Platform.inDebugMode()) break block5;
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
            }
            if (valresult == EvaluationResult.TRUE) {
                return EvaluationResult.TRUE;
            }
            if (valresult == EvaluationResult.NOT_LOADED) continue;
            result = valresult;
        }
        return result;
    }

    private List<ILaunchBinding> getBindings(List<ILaunchBinding> bindings, String mode) {
        Assert.isNotNull(bindings);
        Assert.isNotNull((Object)mode);
        ArrayList<ILaunchBinding> candidates = new ArrayList<ILaunchBinding>();
        for (ILaunchBinding binding : bindings) {
            if (!binding.isValidLaunchMode(mode)) continue;
            candidates.add(binding);
        }
        return candidates;
    }

    private ILaunchBinding getBinding(List<ILaunchBinding> bindings, String mode) {
        Assert.isNotNull(bindings);
        Assert.isNotNull((Object)mode);
        ILaunchBinding binding = null;
        List<ILaunchBinding> candidates = this.getBindings(bindings, mode);
        int i = 0;
        while (i < candidates.size()) {
            if (binding == null) {
                binding = candidates.get(i);
            }
            int j = 0;
            while (j < candidates.size()) {
                ILaunchBinding cj = candidates.get(j);
                if (cj instanceof IOverwritableLaunchBinding && ((IOverwritableLaunchBinding)cj).overwrites(binding.getId())) {
                    binding = cj;
                }
                ++j;
            }
            ++i;
        }
        return binding;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        toString.append("LaunchConfigTypeBinding(");
        toString.append(this.typeId);
        toString.append(")");
        return toString.toString();
    }
}

