/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.internal.executors;

import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.runtime.concurrent.interfaces.IExecutor;
import org.eclipse.tcf.te.runtime.concurrent.interfaces.INestableExecutor;
import org.eclipse.tcf.te.runtime.concurrent.interfaces.ISingleThreadedExecutor;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.ui.PlatformUI;

public class SWTDisplayExecutor
extends ExecutableExtension
implements IExecutor,
ISingleThreadedExecutor,
INestableExecutor {
    public void execute(Runnable command) {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(command);
        } else {
            Display display = Display.findDisplay((Thread)Thread.currentThread());
            if (display != null && !display.isDisposed()) {
                display.asyncExec(command);
            } else {
                UIPlugin.getTraceHandler().trace("DROPPED display command invocation. No display instance found.!", 1, (Object)this);
            }
        }
    }

    public boolean isExecutorThread() {
        return this.isExecutorThread(Thread.currentThread());
    }

    public boolean isExecutorThread(Thread thread) {
        if (thread != null) {
            if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                return thread.equals(PlatformUI.getWorkbench().getDisplay().getThread());
            }
            Display display = Display.findDisplay((Thread)thread);
            if (display != null && !display.isDisposed()) {
                return thread.equals(display.getThread());
            }
        }
        return false;
    }

    public int getMaxDepth() {
        return 1;
    }

    public boolean readAndExecute() {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            return PlatformUI.getWorkbench().getDisplay().readAndDispatch();
        }
        Display display = Display.getCurrent();
        if (display != null && !display.isDisposed()) {
            return display.readAndDispatch();
        }
        return false;
    }
}

