/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.IWorkbenchPage;

public class ShowHistoryAction
extends CVSAction {
    protected ICVSRemoteFile[] getSelectedRemoteFiles() {
        ArrayList<Object> resources = null;
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty()) {
            resources = new ArrayList<Object>();
            for (Object next : selection) {
                IAdaptable a;
                Object adapter;
                if (next instanceof ICVSRemoteFile) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable) || !((adapter = (a = (IAdaptable)next).getAdapter(ICVSRemoteFile.class)) instanceof ICVSRemoteFile)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            ICVSRemoteFile[] result = new ICVSRemoteFile[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new ICVSRemoteFile[0];
    }

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        this.run(monitor -> {
            ICVSRemoteFile[] files = this.getSelectedRemoteFiles();
            TeamUI.showHistoryFor((IWorkbenchPage)this.getTargetPage(), (Object)files[0], null);
        }, false, 2);
    }

    @Override
    public boolean isEnabled() {
        ICVSRemoteFile[] resources = this.getSelectedRemoteFiles();
        return resources.length == 1;
    }

    @Override
    protected String getErrorTitle() {
        return CVSUIMessages.ShowHistoryAction_showHistory;
    }
}

