/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ide.internal;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.ide.internal.IDETipManager;
import org.eclipse.tips.ide.internal.Messages;
import org.eclipse.tips.ide.internal.TipsPreferences;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Startup
implements IStartup {
    private static final String DBLQUOTE = "\"";
    private static final String EQ = "=";
    private static final String SLASH = "/";
    private static final String LT = "<";
    private static final String EMPTY = "";
    private static final String GT = ">";
    private static final String SPACE = " ";

    public void earlyStartup() {
        if (TipsPreferences.getStartupBehavior() != 2) {
            Job job = new Job(Messages.Startup_1){

                protected IStatus run(IProgressMonitor monitor) {
                    Startup.this.start();
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return Startup.class.equals(family);
                }
            };
            job.setSystem(true);
            job.setUser(false);
            job.schedule();
        }
    }

    public void start() {
        Startup.loadProviders();
        Startup.openManager();
    }

    public static void loadProviders() {
        IConfigurationElement[] elements;
        HashSet<String> disabledProviders = new HashSet<String>(TipsPreferences.getDisabledProviderIds());
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tips.core.tips");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("provider")) {
                try {
                    TipProvider provider = (TipProvider)element.createExecutableExtension("class");
                    provider.setExpression(Startup.getExpression(element));
                    String providerId = provider.getID();
                    boolean isDisabled = disabledProviders.contains(providerId);
                    if (!isDisabled) {
                        IDETipManager.getInstance().register(provider);
                    }
                }
                catch (CoreException e) {
                    Startup.log(e);
                }
            }
            ++n2;
        }
    }

    private static String getExpression(IConfigurationElement element) {
        IConfigurationElement[] enablements = element.getChildren("enablement");
        if (enablements.length == 0) {
            return null;
        }
        IConfigurationElement enablement = enablements[0];
        String result = Startup.getXML(enablement.getChildren());
        return result;
    }

    private static String getXML(IConfigurationElement[] children) {
        String result = EMPTY;
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IConfigurationElement[] myChildren = element.getChildren();
            result = String.valueOf(result) + LT + element.getName() + SPACE + Startup.getXMLAttributes(element) + GT;
            if (myChildren.length > 0) {
                result = String.valueOf(result) + Startup.getXML(myChildren);
            } else {
                String value = element.getValue();
                result = String.valueOf(result) + (value == null ? EMPTY : value);
            }
            result = String.valueOf(result) + "</" + element.getName() + GT;
            ++n2;
        }
        return result;
    }

    private static String getXMLAttributes(IConfigurationElement element) {
        String result = EMPTY;
        String[] stringArray = element.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result = String.valueOf(result) + name;
            result = String.valueOf(result) + "=\"";
            result = String.valueOf(result) + element.getAttribute(name);
            result = String.valueOf(result) + "\" ";
            ++n2;
        }
        return result;
    }

    private static void openManager() {
        if (IDETipManager.getInstance().hasContent()) {
            Startup.getOpenUIJob().schedule();
        } else {
            Startup.getWaitJob().schedule();
        }
    }

    private static Job getWaitJob() {
        Job waitJob = new Job(Messages.Startup_18){

            protected IStatus run(IProgressMonitor pMonitor) {
                int attempts = 3;
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)attempts);
                int i = 0;
                while (i < attempts) {
                    monitor.setTaskName(String.valueOf(Messages.Startup_19) + i);
                    if (this.openOrSleep(monitor)) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    ++i;
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            private boolean openOrSleep(SubMonitor pMonitor) {
                if (IDETipManager.getInstance().hasContent()) {
                    Startup.getOpenUIJob().schedule();
                    return true;
                }
                if (this.sleep(1000)) {
                    pMonitor.setCanceled(true);
                    return true;
                }
                return false;
            }

            private boolean sleep(int millis) {
                try {
                    Thread.sleep(millis);
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    return true;
                }
            }
        };
        waitJob.setSystem(true);
        return waitJob;
    }

    private static UIJob getOpenUIJob() {
        UIJob uiJob = new UIJob(PlatformUI.getWorkbench().getDisplay(), Messages.Startup_20){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IDETipManager.getInstance().open(true);
                return Status.OK_STATUS;
            }
        };
        return uiJob;
    }

    private static void log(CoreException e) {
        Bundle bundle = FrameworkUtil.getBundle(Startup.class);
        Status status = new Status(4, bundle.getSymbolicName(), e.getMessage(), (Throwable)e);
        Platform.getLog((Bundle)bundle).log((IStatus)status);
    }
}

