/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;

public class ThemeAssociationRegistry {
    private final Map<String, EclipseThemeAssociation> scopes = new HashMap<String, EclipseThemeAssociation>();

    public IThemeAssociation getThemeAssociationFor(String scopeName, boolean dark) {
        IThemeAssociation userAssociation = null;
        EclipseThemeAssociation registry = this.scopes.get(scopeName);
        if (registry != null) {
            IThemeAssociation iThemeAssociation = userAssociation = dark ? registry.getDark() : registry.getLight();
        }
        if (userAssociation != null) {
            return userAssociation;
        }
        return null;
    }

    public void register(IThemeAssociation association) {
        boolean dark;
        String scopeName = association.getScopeName();
        EclipseThemeAssociation registry = this.scopes.get(scopeName);
        if (registry == null) {
            registry = new EclipseThemeAssociation();
            this.scopes.put(scopeName, registry);
        }
        if (dark = association.isWhenDark()) {
            registry.setDark(association);
        } else {
            registry.setLight(association);
        }
    }

    public void unregister(IThemeAssociation association) {
        String scopeName = association.getScopeName();
        EclipseThemeAssociation registry = this.scopes.get(scopeName);
        if (registry != null) {
            boolean dark = association.isWhenDark();
            if (dark) {
                registry.setDark(null);
            } else {
                registry.setLight(null);
            }
        }
    }

    public List<IThemeAssociation> getThemeAssociations() {
        ArrayList<IThemeAssociation> associations = new ArrayList<IThemeAssociation>();
        Collection<EclipseThemeAssociation> eclipseAssociations = this.scopes.values();
        for (EclipseThemeAssociation eclipseAssociation : eclipseAssociations) {
            if (eclipseAssociation.getLight() != null) {
                associations.add(eclipseAssociation.getLight());
            }
            if (eclipseAssociation.getDark() == null) continue;
            associations.add(eclipseAssociation.getDark());
        }
        return associations;
    }

    private class EclipseThemeAssociation {
        private IThemeAssociation light;
        private IThemeAssociation dark;

        private EclipseThemeAssociation() {
        }

        public IThemeAssociation getLight() {
            return this.light;
        }

        public void setLight(IThemeAssociation light) {
            this.light = light;
        }

        public IThemeAssociation getDark() {
            return this.dark;
        }

        public void setDark(IThemeAssociation dark) {
            this.dark = dark;
        }
    }
}

