/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.widgets;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.ui.internal.TMUIMessages;

public class GrammarInfoWidget
extends Composite {
    private Text nameText;
    private Text scopeNameText;
    private Text fileTypesText;

    public GrammarInfoWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        super.setLayout((Layout)layout);
        super.setLayoutData((Object)new GridData(1808));
        this.createUI(this);
    }

    private void createUI(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        Label grammarNameLabel = new Label(parent, 0);
        grammarNameLabel.setText(TMUIMessages.GrammarInfoWidget_name_text);
        this.nameText = new Text(parent, 2056);
        this.nameText.setLayoutData((Object)new GridData(768));
        Label grammarScopeNameLabel = new Label(parent, 0);
        grammarScopeNameLabel.setText(TMUIMessages.GrammarInfoWidget_scopeName_text);
        this.scopeNameText = new Text(parent, 2056);
        this.scopeNameText.setLayoutData((Object)new GridData(768));
        Label grammarFileTypesLabel = new Label(parent, 0);
        grammarFileTypesLabel.setText(TMUIMessages.GrammarInfoWidget_fileTypes_text);
        this.fileTypesText = new Text(parent, 2056);
        this.fileTypesText.setLayoutData((Object)new GridData(768));
    }

    public void refresh(IGrammar grammar) {
        if (grammar == null) {
            this.nameText.setText("");
            this.scopeNameText.setText("");
            this.fileTypesText.setText("");
        } else {
            String name = grammar.getName();
            this.nameText.setText(name != null ? name : "");
            String scope = grammar.getScopeName();
            this.scopeNameText.setText(scope != null ? scope : "");
            Collection fileTypes = grammar.getFileTypes();
            String types = fileTypes.stream().map(Object::toString).collect(Collectors.joining(","));
            this.fileTypesText.setText(types);
        }
    }

    public Text getGrammarNameText() {
        return this.nameText;
    }

    public Text getScopeNameText() {
        return this.scopeNameText;
    }

    public Text getFileTypesText() {
        return this.fileTypesText;
    }
}

