/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Collections;
import java.util.Map;
import javax.inject.Named;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.commands.internal.HandlerServiceHandler;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.commands.internal.SetEnabled;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.Policy;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.handlers.HandlerActivation;
import org.eclipse.ui.menus.UIElement;

public class E4HandlerProxy
implements IHandler2,
IHandlerListener,
IElementUpdater {
    public HandlerActivation activation;
    private final Command command;
    private final IHandler handler;
    private boolean logExecute = true;
    private boolean logSetEnabled = true;

    public E4HandlerProxy(Command command, IHandler handler) {
        this.command = command;
        this.handler = handler;
        handler.addHandlerListener((IHandlerListener)this);
    }

    @CanExecute
    public boolean canExecute(IEclipseContext context, @Optional IEvaluationContext staticContext, MApplication application) {
        if (this.handler instanceof IHandler2) {
            IEvaluationContext ctx = staticContext;
            if (ctx == null) {
                ctx = new ExpressionContext(application.getContext());
            }
            ((IHandler2)this.handler).setEnabled((Object)ctx);
        }
        return this.handler.isEnabled();
    }

    @Execute
    public Object execute(IEclipseContext context, @Optional @Named(value="parmMap::") Map parms, @Optional Event trigger, @Optional IEvaluationContext staticContext) throws ExecutionException, NotHandledException {
        IEvaluationContext appContext;
        if (Policy.DEBUG_CMDS) {
            Activator.trace((String)"/trace/commands", (String)("execute " + this.command + " and " + this.handler + " with: " + context), null);
        }
        if ((appContext = staticContext) == null) {
            appContext = new ExpressionContext(context);
        }
        ExecutionEvent event = new ExecutionEvent(this.command, parms == null ? Collections.EMPTY_MAP : parms, (Object)trigger, (Object)appContext);
        if (this.handler != null) {
            if (this.handler.isHandled()) {
                return this.handler.execute(event);
            }
            throw new NotHandledException("Handler " + this.handler + " is not handled for for command " + this.command);
        }
        throw new NotHandledException("There is no handler to execute for command " + this.command);
    }

    public IHandler getHandler() {
        return this.handler;
    }

    public void handlerChanged(HandlerEvent handlerEvent) {
        IEclipseContext appContext;
        IHandler handler = this.command.getHandler();
        if (handler instanceof HandlerServiceHandler && HandlerServiceImpl.lookUpHandler((IEclipseContext)(appContext = ((Workbench)PlatformUI.getWorkbench()).getApplication().getContext()), (String)this.command.getId()) == this) {
            ((HandlerServiceHandler)handler).fireHandlerChanged(handlerEvent);
        }
    }

    @Override
    public void updateElement(UIElement element, Map parameters) {
        if (this.handler instanceof IElementUpdater) {
            ((IElementUpdater)this.handler).updateElement(element, parameters);
        }
    }

    @SetEnabled
    void setEnabled(IEclipseContext context, @Optional IEvaluationContext evalContext) {
        if (evalContext == null) {
            evalContext = new ExpressionContext(context);
        }
        if (this.handler instanceof IHandler2) {
            ((IHandler2)this.handler).setEnabled((Object)evalContext);
        }
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
        this.handler.addHandlerListener(handlerListener);
    }

    public void dispose() {
        this.handler.dispose();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.logExecute) {
            this.logExecute = false;
            Status status = new Status(2, "org.eclipse.ui", "Called handled proxy execute(*) directly" + this.command, (Throwable)new Exception());
            WorkbenchPlugin.log((IStatus)status);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.handler.isEnabled();
    }

    public boolean isHandled() {
        return this.handler.isHandled();
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
        this.handler.removeHandlerListener(handlerListener);
    }

    public void setEnabled(Object evaluationContext) {
        if (this.logSetEnabled) {
            this.logSetEnabled = false;
            Status status = new Status(2, "org.eclipse.ui", "Called handled proxy setEnabled(*) directly" + this.command, (Throwable)new Exception());
            WorkbenchPlugin.log((IStatus)status);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("E4HandlerProxy [");
        builder.append("handler=");
        builder.append(this.handler);
        if (this.command != null) {
            builder.append(", ");
            builder.append("command=");
            builder.append(this.command);
        }
        builder.append("]");
        return builder.toString();
    }
}

