/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdaptable;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanDescriptor;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlan;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanExecutor;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileModifiableMaskedTuple;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public final class LocalSearchMatcher
implements ILocalSearchAdaptable {
    private final List<SearchPlanExecutor> plan;
    private final IPlanDescriptor planDescriptor;
    private final List<ILocalSearchAdapter> adapters;

    public List<SearchPlanExecutor> getPlan() {
        return this.plan;
    }

    @Override
    public List<ILocalSearchAdapter> getAdapters() {
        return new ArrayList<ILocalSearchAdapter>(this.adapters);
    }

    public LocalSearchMatcher(ISearchContext searchContext, IPlanDescriptor planDescriptor, List<SearchPlan> plan) {
        Preconditions.checkArgument((planDescriptor != null ? 1 : 0) != 0, (String)"Cannot initialize matcher with null query.");
        this.planDescriptor = planDescriptor;
        this.plan = plan.stream().map(p -> new SearchPlanExecutor((SearchPlan)p, searchContext)).collect(Collectors.toList());
        this.adapters = new LinkedList<ILocalSearchAdapter>();
    }

    @Override
    public void addAdapter(ILocalSearchAdapter adapter) {
        this.adapters.add(adapter);
        adapter.adapterRegistered(this);
    }

    @Override
    public void removeAdapter(ILocalSearchAdapter adapter) {
        this.adapters.remove(adapter);
        adapter.adapterUnregistered(this);
    }

    @Override
    public void addAdapters(List<ILocalSearchAdapter> adapters) {
        this.adapters.addAll(adapters);
        for (ILocalSearchAdapter adapter : adapters) {
            adapter.adapterRegistered(this);
        }
    }

    @Override
    public void removeAdapters(List<ILocalSearchAdapter> adapters) {
        this.adapters.removeAll(adapters);
        for (ILocalSearchAdapter adapter : adapters) {
            adapter.adapterUnregistered(this);
        }
    }

    public int getParameterCount() {
        return this.planDescriptor.getQuery().getParameters().size();
    }

    private void matchingStarted() {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.patternMatchingStarted(this);
        }
    }

    public Stream<Tuple> streamMatches(Object[] parameterValues) {
        this.matchingStarted();
        PlanExecutionIteratorWithArrayParameters it = new PlanExecutionIteratorWithArrayParameters(this.plan.iterator(), parameterValues);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1281), false);
    }

    public Stream<Tuple> streamMatches(TupleMask parameterSeedMask, ITuple parameterValues) {
        this.matchingStarted();
        PlanExecutionIteratorWithTupleParameters it = new PlanExecutionIteratorWithTupleParameters(this.plan.iterator(), parameterSeedMask, parameterValues);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1281), false);
    }

    public PQuery getQuerySpecification() {
        return this.planDescriptor.getQuery();
    }

    public IPlanDescriptor getPlanDescriptor() {
        return this.planDescriptor;
    }

    private abstract class PlanExecutionIterator
    implements Iterator<Tuple> {
        protected final Iterator<SearchPlanExecutor> planIterator;
        protected SearchPlanExecutor currentPlan;
        protected MatchingFrame frame;
        protected final Set<ITuple> matchSet;
        protected VolatileModifiableMaskedTuple parametersOfFrameView;
        private boolean isNextMatchCalculated;

        public PlanExecutionIterator(Iterator<SearchPlanExecutor> planIterator) {
            this.planIterator = planIterator;
            this.isNextMatchCalculated = false;
            this.matchSet = new HashSet<ITuple>();
        }

        protected boolean selectNextPlan() {
            if (this.currentPlan != null) {
                this.currentPlan.removeAdapters(LocalSearchMatcher.this.adapters);
            }
            boolean validPlanSelected = false;
            SearchPlanExecutor nextPlan = null;
            while (!validPlanSelected && this.planIterator.hasNext()) {
                nextPlan = this.planIterator.next();
                nextPlan.addAdapters(LocalSearchMatcher.this.adapters);
                nextPlan.resetPlan();
                validPlanSelected = this.initializeMatchingFrame(nextPlan);
            }
            if (validPlanSelected) {
                for (ILocalSearchAdapter adapter : LocalSearchMatcher.this.adapters) {
                    adapter.planChanged(Optional.ofNullable(this.currentPlan).map(SearchPlanExecutor::getSearchPlan), Optional.ofNullable(nextPlan).map(SearchPlanExecutor::getSearchPlan));
                }
                this.currentPlan = nextPlan;
                return true;
            }
            this.currentPlan = null;
            return false;
        }

        protected abstract boolean initializeMatchingFrame(SearchPlanExecutor var1);

        private boolean findNextNewMatchInCurrentPlan() {
            boolean foundMatch = this.currentPlan.execute(this.frame);
            while (foundMatch && this.matchSet.contains(this.parametersOfFrameView)) {
                for (ILocalSearchAdapter adapter : LocalSearchMatcher.this.adapters) {
                    adapter.duplicateMatchFound(this.frame);
                }
                foundMatch = this.currentPlan.execute(this.frame);
            }
            return foundMatch;
        }

        @Override
        public boolean hasNext() {
            if (this.isNextMatchCalculated) {
                return true;
            }
            if (this.currentPlan == null) {
                return false;
            }
            boolean foundMatch = this.findNextNewMatchInCurrentPlan();
            while (!foundMatch && this.planIterator.hasNext()) {
                boolean bl = foundMatch = this.selectNextPlan() && this.findNextNewMatchInCurrentPlan();
            }
            if (!foundMatch) {
                for (ILocalSearchAdapter adapter : LocalSearchMatcher.this.adapters) {
                    adapter.noMoreMatchesAvailable(LocalSearchMatcher.this);
                }
            }
            this.isNextMatchCalculated = foundMatch;
            return foundMatch;
        }

        @Override
        public Tuple next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more matches available.");
            }
            this.isNextMatchCalculated = false;
            Tuple match = this.parametersOfFrameView.toImmutable();
            this.matchSet.add((ITuple)match);
            return match;
        }
    }

    private class PlanExecutionIteratorWithArrayParameters
    extends PlanExecutionIterator {
        private final Object[] parameterValues;

        public PlanExecutionIteratorWithArrayParameters(Iterator<SearchPlanExecutor> planIterator, Object[] parameterValues) {
            super(planIterator);
            this.parameterValues = parameterValues;
            this.selectNextPlan();
        }

        @Override
        protected boolean initializeMatchingFrame(SearchPlanExecutor nextPlan) {
            this.frame = new MatchingFrame(nextPlan.getVariableMapping().size());
            this.parametersOfFrameView = new VolatileModifiableMaskedTuple((IModifiableTuple)this.frame, nextPlan.getParameterMask());
            int i = 0;
            while (i < this.parameterValues.length) {
                Object valueToSet = this.parameterValues[i];
                if (valueToSet != null) {
                    Object oldValue = this.parametersOfFrameView.get(i);
                    if (oldValue == null) {
                        this.parametersOfFrameView.set(i, valueToSet);
                    } else if (!Objects.equals(valueToSet, oldValue)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
    }

    private class PlanExecutionIteratorWithTupleParameters
    extends PlanExecutionIterator {
        private final ITuple parameterValues;
        private final TupleMask parameterSeedMask;

        public PlanExecutionIteratorWithTupleParameters(Iterator<SearchPlanExecutor> planIterator, TupleMask parameterSeedMask, ITuple parameterValues) {
            super(planIterator);
            this.parameterSeedMask = parameterSeedMask;
            this.parameterValues = parameterValues;
            this.selectNextPlan();
        }

        @Override
        protected boolean initializeMatchingFrame(SearchPlanExecutor nextPlan) {
            this.frame = new MatchingFrame(nextPlan.getVariableMapping().size());
            this.parametersOfFrameView = new VolatileModifiableMaskedTuple((IModifiableTuple)this.frame, nextPlan.getParameterMask());
            int i = 0;
            while (i < this.parameterSeedMask.getSize()) {
                int index = this.parameterSeedMask.indices[i];
                Object valueToSet = this.parameterValues.get(i);
                if (valueToSet != null) {
                    Object oldValue = this.parametersOfFrameView.get(index);
                    if (oldValue == null) {
                        this.parametersOfFrameView.set(index, valueToSet);
                    } else if (!Objects.equals(valueToSet, oldValue)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
    }
}

