/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.index;

import java.util.List;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.rete.index.IndexerListener;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.index.StandardIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;

public abstract class SpecializedProjectionIndexer
extends StandardIndexer
implements ProjectionIndexer {
    protected Node activeNode;
    protected List<ListenerSubscription> sharedSubscriptionList;

    public SpecializedProjectionIndexer(ReteContainer reteContainer, TupleMask mask, Supplier parent, Node activeNode, List<ListenerSubscription> sharedSubscriptionList) {
        super(reteContainer, mask);
        this.parent = parent;
        this.activeNode = activeNode;
        this.sharedSubscriptionList = sharedSubscriptionList;
    }

    @Override
    public Node getActiveNode() {
        return this.activeNode;
    }

    @Override
    protected void propagate(Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attachListener(IndexerListener listener) {
        super.attachListener(listener);
        ListenerSubscription subscription = new ListenerSubscription(this, listener);
        this.sharedSubscriptionList.add(0, subscription);
    }

    @Override
    public void detachListener(IndexerListener listener) {
        super.detachListener(listener);
        ListenerSubscription subscription = new ListenerSubscription(this, listener);
        this.sharedSubscriptionList.remove(subscription);
    }

    public abstract void propagateToListener(IndexerListener var1, Direction var2, Tuple var3, Timestamp var4);

    public static class ListenerSubscription {
        protected SpecializedProjectionIndexer indexer;
        protected IndexerListener listener;

        public ListenerSubscription(SpecializedProjectionIndexer indexer, IndexerListener listener) {
            this.indexer = indexer;
            this.listener = listener;
        }

        public void propagate(Direction direction, Tuple updateElement, Timestamp timestamp) {
            this.indexer.propagateToListener(this.listener, direction, updateElement, timestamp);
        }

        public int hashCode() {
            return Objects.hash(this.indexer, this.listener);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListenerSubscription other = (ListenerSubscription)obj;
            return Objects.equals(this.listener, other.listener) && Objects.equals(this.indexer, other.indexer);
        }
    }
}

