/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api.adapter;

import java.util.Iterator;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.Context;
import org.eclipse.viatra.transformation.evm.api.IExecutor;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableEVM;

public class AdaptableExecutor
implements IExecutor {
    private final IExecutor delegatedExecutor;
    private final AdaptableEVM evm;

    public AdaptableExecutor(IExecutor delegatedExecutor, AdaptableEVM evm) {
        this.delegatedExecutor = delegatedExecutor;
        this.evm = evm;
    }

    @Override
    public void startExecution(String transactionID) {
        this.evm.startTransaction(transactionID);
    }

    @Override
    public void execute(Iterator<Activation<?>> activations) {
        Iterator<Activation<?>> ac = this.evm.getExecutableActivations(activations);
        while (ac.hasNext()) {
            Activation<?> activation = ac.next();
            this.evm.beforeFiring(activation);
            activation.fire(this.getContext());
            this.evm.afterFiring(activation);
        }
    }

    @Override
    public void endExecution(String transactionID) {
        this.evm.endTransaction(transactionID);
    }

    @Override
    public Context getContext() {
        return this.delegatedExecutor.getContext();
    }
}

