/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.category;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.PropertyManager;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProvider;

public final class PropertyCategoryProviders {
    private static final PropertyCategoryProvider FROM_PROPERTY = new PropertyCategoryProvider(){

        @Override
        public PropertyCategory getCategory(Property property) {
            return property.getCategory();
        }
    };
    private static final PropertyCategoryProvider FORCED_BY_USER = new PropertyCategoryProvider(){

        @Override
        public PropertyCategory getCategory(Property property) {
            return PropertyManager.getCategoryForced(property);
        }
    };
    private static final PropertyCategoryProvider DEF = PropertyCategoryProviders.combine(PropertyCategoryProviders.forcedByUser(), PropertyCategoryProviders.fromProperty());

    public static PropertyCategoryProvider fromProperty() {
        return FROM_PROPERTY;
    }

    public static PropertyCategoryProvider forcedByUser() {
        return FORCED_BY_USER;
    }

    public static PropertyCategoryProvider combine(final PropertyCategoryProvider ... providers) {
        return new PropertyCategoryProvider(){

            @Override
            public PropertyCategory getCategory(Property property) {
                PropertyCategoryProvider[] propertyCategoryProviderArray = providers;
                int n = providers.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyCategoryProvider provider = propertyCategoryProviderArray[n2];
                    PropertyCategory category = provider.getCategory(property);
                    if (category != null) {
                        return category;
                    }
                    ++n2;
                }
                throw new IllegalStateException("Can not provide category for " + property.getTitle());
            }
        };
    }

    public static PropertyCategoryProvider def() {
        return DEF;
    }
}

