"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function removeDuplicates(arr, prop) {
    const new_arr = [];
    const lookup = {};
    for (const i in arr) {
        lookup[arr[i][prop]] = arr[i];
    }
    for (const i in lookup) {
        new_arr.push(lookup[i]);
    }
    return new_arr;
}
exports.removeDuplicates = removeDuplicates;
function getLineOffsets(textDocString) {
    const lineOffsets = [];
    const text = textDocString;
    let isLineStart = true;
    for (let i = 0; i < text.length; i++) {
        if (isLineStart) {
            lineOffsets.push(i);
            isLineStart = false;
        }
        const ch = text.charAt(i);
        isLineStart = (ch === '\r' || ch === '\n');
        if (ch === '\r' && i + 1 < text.length && text.charAt(i + 1) === '\n') {
            i++;
        }
    }
    if (isLineStart && text.length > 0) {
        lineOffsets.push(text.length);
    }
    return lineOffsets;
}
exports.getLineOffsets = getLineOffsets;
function removeDuplicatesObj(objArray) {
    const nonDuplicateSet = new Set();
    const nonDuplicateArr = [];
    for (const obj in objArray) {
        const currObj = objArray[obj];
        const stringifiedObj = JSON.stringify(currObj);
        if (!nonDuplicateSet.has(stringifiedObj)) {
            nonDuplicateArr.push(currObj);
            nonDuplicateSet.add(stringifiedObj);
        }
    }
    return nonDuplicateArr;
}
exports.removeDuplicatesObj = removeDuplicatesObj;
function matchOffsetToDocument(offset, jsonDocuments) {
    for (const jsonDoc in jsonDocuments.documents) {
        const currJsonDoc = jsonDocuments.documents[jsonDoc];
        if (currJsonDoc.root && currJsonDoc.root.end >= offset && currJsonDoc.root.start <= offset) {
            return currJsonDoc;
        }
    }
    // TODO: Fix this so that it returns the correct document
    return jsonDocuments.documents[0];
}
exports.matchOffsetToDocument = matchOffsetToDocument;
function matchOffsetToDocument2(offset, jsonDocuments) {
    for (const jsonDoc of jsonDocuments.documents) {
        if (jsonDoc.root && jsonDoc.root.offset <= offset && (jsonDoc.root.length + jsonDoc.root.offset) >= offset) {
            return jsonDoc;
        }
    }
    // TODO: Fix this so that it returns the correct document
    return null;
}
exports.matchOffsetToDocument2 = matchOffsetToDocument2;
function filterInvalidCustomTags(customTags) {
    const validCustomTags = ['mapping', 'scalar', 'sequence'];
    return customTags.filter(tag => {
        if (typeof tag === 'string') {
            const typeInfo = tag.split(' ');
            const type = (typeInfo[1] && typeInfo[1].toLowerCase()) || 'scalar';
            // We need to check if map is a type because map will throw an error within the yaml-ast-parser
            if (type === 'map') {
                return false;
            }
            return validCustomTags.indexOf(type) !== -1;
        }
        return false;
    });
}
exports.filterInvalidCustomTags = filterInvalidCustomTags;
//# sourceMappingURL=arrUtils.js.map