import { DocumentSymbol, SymbolKind } from 'vscode-languageserver-types';
export declare function createExpectedError(message: string, startLine: number, startCharacter: number, endLine: number, endCharacter: number, severity?: number): {
    message: string;
    range: {
        start: {
            line: number;
            character: number;
        };
        end: {
            line: number;
            character: number;
        };
    };
    severity: number;
};
export declare function createExpectedSymbolInformation(name: string, kind: number, containerName: string | undefined, uri: string, startLine: number, startCharacter: number, endLine: number, endCharacter: number): {
    name: string;
    kind: number;
    containerName: string;
    location: {
        uri: string;
        range: {
            start: {
                line: number;
                character: number;
            };
            end: {
                line: number;
                character: number;
            };
        };
    };
};
export declare function createExpectedDocumentSymbol(name: string, kind: SymbolKind, startLine: number, startCharacter: number, endLine: number, endCharacter: number, startLineSelection: number, startCharacterSelection: number, endLineSelection: number, endCharacterSelection: number, children?: DocumentSymbol[]): {
    name: string;
    kind: SymbolKind;
    range: {
        start: {
            character: number;
            line: number;
        };
        end: {
            character: number;
            line: number;
        };
    };
    selectionRange: {
        start: {
            character: number;
            line: number;
        };
        end: {
            character: number;
            line: number;
        };
    };
    children: DocumentSymbol[];
};
