/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap;

import java.util.Comparator;
import org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap.SourceMapInfo;

class SourceMapInfoEntry {
    private static Comparator<SourceMapInfoEntry> COMPARATOR = new Comparator<SourceMapInfoEntry>(){

        @Override
        public int compare(SourceMapInfoEntry val1, SourceMapInfoEntry val2) {
            return val1.line - val2.line;
        }
    };
    public int line;
    public int column;
    public int endColumn = -1;
    public SourceMapInfo info;

    public static SourceMapInfoEntry forLine(int line) {
        return new SourceMapInfoEntry(line, 0, null);
    }

    public static Comparator<SourceMapInfoEntry> lineComparator() {
        return COMPARATOR;
    }

    SourceMapInfoEntry(int line, int column, SourceMapInfo info) {
        this.line = line;
        this.column = column;
        this.info = info;
    }

    public SourceMapInfo getInfo() {
        return this.info;
    }

    public String toString() {
        return "[" + this.line + ":" + this.column + "," + this.endColumn + "] ==> " + this.info.toString();
    }

    void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }
}

