/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.transport.packet;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.debug.transport.Connection;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.packet.PacketManager;

public final class PacketSendManager
extends PacketManager {
    private final List outgoingPackets = new ArrayList();

    public PacketSendManager(Connection connection) {
        super(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        super.disconnect();
        List list = this.outgoingPackets;
        synchronized (list) {
            this.outgoingPackets.notifyAll();
        }
    }

    @Override
    public void run() {
        while (!this.isDisconnected()) {
            try {
                this.sendAvailablePackets();
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
            }
            catch (InterruptedIOException e) {
                this.disconnect(e);
            }
            catch (IOException e) {
                this.disconnect(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) throws DisconnectedException {
        if (packet == null) {
            throw new IllegalArgumentException("You cannot send a null packet");
        }
        if (this.isDisconnected()) {
            throw new DisconnectedException("Runtime disconnected", this.getDisconnectedException());
        }
        List list = this.outgoingPackets;
        synchronized (list) {
            this.outgoingPackets.add(packet);
            this.outgoingPackets.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAvailablePackets() throws InterruptedException, IOException {
        Object[] packetsToSend;
        List list = this.outgoingPackets;
        synchronized (list) {
            while (this.outgoingPackets.size() == 0) {
                this.outgoingPackets.wait();
            }
            packetsToSend = this.outgoingPackets.toArray();
            this.outgoingPackets.clear();
        }
        int i = 0;
        while (i < packetsToSend.length) {
            this.getConnection().writePacket((Packet)packetsToSend[i]);
            ++i;
        }
    }
}

