/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.validation.Issue;

public class AbstractDeclarativeQuickfixProvider
implements IssueResolutionProvider {
    private static final Logger LOG = Logger.getLogger(AbstractDeclarativeQuickfixProvider.class);
    @Inject
    private Provider<IssueResolutionAcceptor> issueResolutionAcceptorProvider;

    protected Predicate<Method> getFixMethodPredicate(final String issueCode) {
        return new Predicate<Method>(){

            public boolean apply(Method input) {
                Fix[] fixArray = (Fix[])input.getAnnotationsByType(Fix.class);
                int n = fixArray.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean result;
                    Fix annotation = fixArray[n2];
                    boolean bl = result = annotation != null && issueCode.equals(annotation.value()) && input.getParameterTypes().length == 2 && Void.TYPE == input.getReturnType() && input.getParameterTypes()[0].isAssignableFrom(Issue.class) && input.getParameterTypes()[1].isAssignableFrom(IssueResolutionAcceptor.class);
                    if (result) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    protected List<IssueResolution> getResolutions(Issue issue, List<Method> fixMethods) {
        IssueResolutionAcceptor issueResolutionAcceptor = (IssueResolutionAcceptor)this.issueResolutionAcceptorProvider.get();
        for (Method fixMethod : fixMethods) {
            try {
                fixMethod.setAccessible(true);
                fixMethod.invoke((Object)this, issue, issueResolutionAcceptor);
            }
            catch (Exception e) {
                LOG.error((Object)"Error executing fix method", (Throwable)e);
            }
        }
        return issueResolutionAcceptor.getIssueResolutions();
    }

    protected Iterable<Method> collectMethods(Class<? extends AbstractDeclarativeQuickfixProvider> clazz, String issueCode) {
        ArrayList methods = Lists.newArrayList((Object[])clazz.getMethods());
        return Iterables.filter((Iterable)methods, this.getFixMethodPredicate(issueCode));
    }

    protected List<Method> getFixMethods(Issue issue) {
        return Lists.newArrayList(this.collectMethods(this.getClass(), issue.getCode()));
    }

    @Override
    public boolean hasResolutionFor(String issueCode) {
        if (issueCode == null) {
            return false;
        }
        Iterable<Method> methods = this.collectMethods(this.getClass(), issueCode);
        return methods.iterator().hasNext();
    }

    @Override
    public List<IssueResolution> getResolutions(Issue issue) {
        List<Method> fixMethods = this.getFixMethods(issue);
        return this.getResolutions(issue, fixMethods);
    }

    protected Provider<IssueResolutionAcceptor> getIssueResolutionAcceptorProvider() {
        return this.issueResolutionAcceptorProvider;
    }

    public void setIssueResolutionAcceptorProvider(Provider<IssueResolutionAcceptor> issueResolutionAcceptorProvider) {
        this.issueResolutionAcceptorProvider = issueResolutionAcceptorProvider;
    }
}

