/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.contentassist;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IdeCrossrefProposalProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class XbaseIdeCrossrefProposalProvider
extends IdeCrossrefProposalProvider {
    @Inject
    private CommonTypeComputationServices typeComputationServices;

    public ContentAssistEntry createProposal(IEObjectDescription candidate, CrossReference crossRef, ContentAssistContext context) {
        boolean _hasIdRule = this.hasIdRule(crossRef);
        if (_hasIdRule) {
            ProposalBracketInfo bracketInfo = this.getProposalBracketInfo(candidate, context);
            String _string = this.getQualifiedNameConverter().toString(candidate.getName());
            String proposalString = _string + bracketInfo.brackets;
            int _xifexpression = 0;
            _xifexpression = candidate instanceof IIdentifiableElementDescription ? ((IIdentifiableElementDescription)candidate).getNumberOfIrrelevantParameters() : 0;
            int insignificantParameters = _xifexpression;
            LightweightTypeReferenceFactory converter = this.getTypeConverter(context.getResource());
            EObject objectOrProxy = candidate.getEObjectOrProxy();
            Procedures.Procedure1 _function = result -> {
                result.setKind("REFERENCE");
                if (objectOrProxy instanceof JvmFeature) {
                    boolean _startsWith = bracketInfo.brackets.startsWith(" =");
                    if (_startsWith) {
                        String _string_1 = this.getQualifiedNameConverter().toString(candidate.getName());
                        String _plus = _string_1 + bracketInfo.brackets;
                        this.addNameAndDescription((ContentAssistEntry)result, (JvmFeature)objectOrProxy, false, insignificantParameters, _plus, converter);
                    } else {
                        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)bracketInfo.brackets);
                        boolean _not = !_isNullOrEmpty;
                        this.addNameAndDescription((ContentAssistEntry)result, (JvmFeature)objectOrProxy, _not, insignificantParameters, this.getQualifiedNameConverter().toString(candidate.getName()), converter);
                    }
                } else {
                    this.addNameAndDescription((ContentAssistEntry)result, objectOrProxy, this.getQualifiedNameConverter().toString(candidate.getQualifiedName()), this.getQualifiedNameConverter().toString(candidate.getName()));
                }
                int _offset = context.getOffset();
                int _length = context.getPrefix().length();
                int _minus = _offset - _length;
                int _length_1 = proposalString.length();
                int offset = _minus + _length_1;
                result.setEscapePosition(Integer.valueOf(offset + bracketInfo.caretOffset));
                if (bracketInfo.selectionOffset != 0) {
                    int _offset_1 = offset;
                    offset = _offset_1 + bracketInfo.selectionOffset;
                    ArrayList _editPositions = result.getEditPositions();
                    TextRegion _textRegion = new TextRegion(offset, bracketInfo.selectionLength);
                    _editPositions.add(_textRegion);
                }
                if (objectOrProxy instanceof JvmExecutable) {
                    StringBuilder parameterList = new StringBuilder();
                    this.appendParameters(parameterList, (JvmExecutable)objectOrProxy, insignificantParameters, converter);
                }
            };
            return this.getProposalCreator().createProposal(proposalString, context, _function);
        }
        return super.createProposal(candidate, crossRef, context);
    }

    protected boolean hasIdRule(CrossReference crossRef) {
        AbstractElement _terminal = crossRef.getTerminal();
        if (_terminal instanceof RuleCall) {
            AbstractElement _terminal_1 = crossRef.getTerminal();
            String ruleName = ((RuleCall)_terminal_1).getRule().getName();
            return Objects.equal((Object)ruleName, (Object)"IdOrSuper") || Objects.equal((Object)ruleName, (Object)"ValidID") || Objects.equal((Object)ruleName, (Object)"FeatureCallID");
        }
        return false;
    }

    protected ProposalBracketInfo getProposalBracketInfo(IEObjectDescription proposedDescription, ContentAssistContext contentAssistContext) {
        ProposalBracketInfo info = new ProposalBracketInfo();
        if (proposedDescription instanceof IIdentifiableElementDescription) {
            boolean _isExplicitOperationCall;
            JvmIdentifiableElement jvmFeature = ((IIdentifiableElementDescription)proposedDescription).getElementOrProxy();
            if (jvmFeature instanceof JvmExecutable) {
                boolean _equals;
                EList parameters = ((JvmExecutable)jvmFeature).getParameters();
                int _numberOfParameters = ((IIdentifiableElementDescription)proposedDescription).getNumberOfParameters();
                boolean bl = _equals = _numberOfParameters == 1;
                if (_equals) {
                    if (((JvmExecutable)jvmFeature).getSimpleName().startsWith("set") && !((IIdentifiableElementDescription)proposedDescription).getName().getFirstSegment().startsWith("set")) {
                        info.brackets = " = value";
                        int _length = "value".length();
                        int _minus = -_length;
                        info.selectionOffset = _minus;
                        info.selectionLength = "value".length();
                        return info;
                    }
                    JvmTypeReference parameterType = ((JvmFormalParameter)IterableExtensions.last((Iterable)parameters)).getParameterType();
                    LightweightTypeReference light = this.getTypeConverter(contentAssistContext.getResource()).toLightweightReference(parameterType);
                    boolean _isFunctionType = light.isFunctionType();
                    if (_isFunctionType) {
                        int numParameters = light.getAsFunctionTypeReference().getParameterTypes().size();
                        if (numParameters == 1) {
                            info.brackets = "[]";
                            info.caretOffset = -1;
                            return info;
                        }
                        if (numParameters == 0) {
                            info.brackets = "[|]";
                            info.caretOffset = -1;
                            return info;
                        }
                        StringBuilder b = new StringBuilder();
                        for (int i = 0; i < numParameters; ++i) {
                            if (i != 0) {
                                b.append(", ");
                            }
                            b.append("p" + Integer.valueOf(i + 1));
                        }
                        String _string = b.toString();
                        String _plus = "[" + _string;
                        String _plus_1 = _plus + "|]";
                        info.brackets = _plus_1;
                        info.caretOffset = -1;
                        int _length_1 = b.length();
                        int _minus_1 = -_length_1;
                        int _minus_2 = _minus_1 - 2;
                        info.selectionOffset = _minus_2;
                        info.selectionLength = b.length();
                        return info;
                    }
                }
            }
            if (_isExplicitOperationCall = this.isExplicitOperationCall((IIdentifiableElementDescription)proposedDescription)) {
                info.brackets = "()";
                info.selectionOffset = -1;
            }
        }
        return info;
    }

    protected LightweightTypeReferenceFactory getTypeConverter(XtextResource context) {
        StandardTypeReferenceOwner _standardTypeReferenceOwner = new StandardTypeReferenceOwner(this.typeComputationServices, (Resource)context);
        return new LightweightTypeReferenceFactory((ITypeReferenceOwner)_standardTypeReferenceOwner){

            public LightweightTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                LightweightTypeReference result = super.doVisitParameterizedTypeReference(reference);
                boolean _isFunctionType = result.isFunctionType();
                if (_isFunctionType) {
                    return result.tryConvertToFunctionTypeReference(false);
                }
                return result;
            }
        };
    }

    protected void addNameAndDescription(ContentAssistEntry entry, JvmFeature feature, boolean withParents, int insignificantParameters, String shortName, LightweightTypeReferenceFactory converter) {
        StringBuilder labelBuilder = new StringBuilder(shortName);
        StringBuilder descriptionBuilder = new StringBuilder();
        if (feature instanceof JvmOperation) {
            JvmTypeReference returnType;
            if (withParents) {
                labelBuilder.append("(");
                this.appendParameters(labelBuilder, (JvmExecutable)feature, insignificantParameters, converter);
                labelBuilder.append(")");
            }
            if ((returnType = ((JvmOperation)feature).getReturnType()) != null && returnType.getSimpleName() != null) {
                labelBuilder.append(" : ");
                labelBuilder.append(converter.toLightweightReference(returnType).getHumanReadableName());
            }
            descriptionBuilder.append(converter.toPlainTypeReference((JvmType)((JvmOperation)feature).getDeclaringType()).getHumanReadableName());
            if (!withParents) {
                descriptionBuilder.append(".");
                descriptionBuilder.append(((JvmOperation)feature).getSimpleName());
                descriptionBuilder.append("()");
            }
        } else if (feature instanceof JvmField) {
            String fieldType;
            boolean _tripleNotEquals;
            labelBuilder.append(" : ");
            JvmTypeReference _type = ((JvmField)feature).getType();
            boolean bl = _tripleNotEquals = _type != null;
            if (_tripleNotEquals && (fieldType = converter.toLightweightReference(((JvmField)feature).getType()).getHumanReadableName()) != null) {
                labelBuilder.append(fieldType);
            }
            descriptionBuilder.append(converter.toPlainTypeReference((JvmType)((JvmField)feature).getDeclaringType()).getHumanReadableName());
        } else if (feature instanceof JvmConstructor && withParents) {
            labelBuilder.append("(");
            this.appendParameters(labelBuilder, (JvmExecutable)feature, insignificantParameters, converter);
            labelBuilder.append(")");
        }
        entry.setLabel(labelBuilder.toString());
        entry.setDescription(descriptionBuilder.toString());
    }

    protected void addNameAndDescription(ContentAssistEntry entry, EObject element, String qualifiedNameAsString, String shortName) {
        boolean _greaterThan;
        QualifiedName qualifiedName = this.getQualifiedNameConverter().toQualifiedName(qualifiedNameAsString);
        int _segmentCount = qualifiedName.getSegmentCount();
        boolean bl = _greaterThan = _segmentCount > 1;
        if (_greaterThan) {
            entry.setLabel(qualifiedName.getLastSegment());
            entry.setDescription(qualifiedNameAsString);
        } else {
            entry.setLabel(qualifiedNameAsString);
        }
    }

    protected void appendParameters(StringBuilder result, JvmExecutable executable, int insignificantParameters, LightweightTypeReferenceFactory ownedConverter) {
        EList declaredParameters = executable.getParameters();
        List relevantParameters = declaredParameters.subList(Math.min(insignificantParameters, declaredParameters.size()), declaredParameters.size());
        for (int i = 0; i < relevantParameters.size(); ++i) {
            JvmFormalParameter parameter = (JvmFormalParameter)relevantParameters.get(i);
            if (i != 0) {
                result.append(", ");
            }
            if (i == relevantParameters.size() - 1 && executable.isVarArgs() && parameter.getParameterType() instanceof JvmGenericArrayTypeReference) {
                JvmTypeReference _parameterType = parameter.getParameterType();
                JvmGenericArrayTypeReference parameterType = (JvmGenericArrayTypeReference)_parameterType;
                result.append(ownedConverter.toLightweightReference(parameterType.getComponentType()).getHumanReadableName());
                result.append("...");
            } else {
                String simpleName;
                boolean _tripleNotEquals;
                JvmTypeReference _parameterType_1 = parameter.getParameterType();
                boolean bl = _tripleNotEquals = _parameterType_1 != null;
                if (_tripleNotEquals && (simpleName = ownedConverter.toLightweightReference(parameter.getParameterType()).getHumanReadableName()) != null) {
                    result.append(simpleName);
                }
            }
            result.append(" ");
            result.append(String.valueOf(parameter.getName()));
        }
    }

    protected boolean isExplicitOperationCall(IIdentifiableElementDescription desc) {
        int _numberOfParameters = desc.getNumberOfParameters();
        return _numberOfParameters > 0;
    }

    public static class ProposalBracketInfo {
        private String brackets = "";
        private int selectionOffset = 0;
        private int selectionLength = 0;
        private int caretOffset = 0;
    }
}

