/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.choreography;

import java.util.List;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.modeler.core.features.AbstractLayoutBpmn2ShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.choreography.UpdateChoreographyLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class LayoutChoreographyFeature
extends AbstractLayoutBpmn2ShapeFeature {
    protected IPeService peService = Graphiti.getPeService();
    protected IGaService gaService = Graphiti.getGaService();

    public LayoutChoreographyFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (!(pe instanceof ContainerShape)) {
            return false;
        }
        return BusinessObjectUtil.getFirstElementOfType(pe, ChoreographyActivity.class) != null;
    }

    public boolean layout(ILayoutContext context) {
        ContainerShape choreographyActivityShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm parentGa = choreographyActivityShape.getGraphicsAlgorithm();
        int newWidth = parentGa.getWidth();
        int newHeight = parentGa.getHeight();
        Shape rectShape = (Shape)choreographyActivityShape.getChildren().get(0);
        this.gaService.setSize(rectShape.getGraphicsAlgorithm(), newWidth, newHeight);
        int minY = newHeight;
        List<ContainerShape> bandShapes = FeatureSupport.getParticipantBandContainerShapes(choreographyActivityShape);
        for (ContainerShape b : bandShapes) {
            int y;
            BPMNShape bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)b, BPMNShape.class);
            ParticipantBandKind bandKind = bpmnShape.getParticipantBandKind();
            if (bandKind != ParticipantBandKind.BOTTOM_INITIATING && bandKind != ParticipantBandKind.BOTTOM_NON_INITIATING && bandKind != ParticipantBandKind.MIDDLE_NON_INITIATING || (y = b.getGraphicsAlgorithm().getY()) >= minY) continue;
            minY = y;
        }
        ShapeDecoratorUtil.setActivityMarkerOffest(choreographyActivityShape, newHeight - minY);
        ShapeDecoratorUtil.layoutActivityMarker(choreographyActivityShape);
        UpdateChoreographyLabelFeature feature = new UpdateChoreographyLabelFeature(this.getFeatureProvider());
        UpdateContext updateContext = new UpdateContext((PictogramElement)choreographyActivityShape);
        feature.update((IUpdateContext)updateContext);
        return true;
    }
}

