/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class FlatButton
extends Canvas {
    protected String fText;
    protected int fMargin = 4;
    protected Cursor fHandCursor = this.getDisplay().getSystemCursor(21);

    public FlatButton(Composite parent, int flags) {
        super(parent, flags);
        this.setCursor(this.fHandCursor);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FlatButton.this.onPaint(e);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                FlatButton.this.onSelection(e);
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void setText(String text) {
        this.fText = text;
    }

    public String getText() {
        return this.fText;
    }

    public void setMargin(int margin) {
        this.fMargin = margin;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.computeSize(wHint, hHint);
    }

    public Point computeSize(int wHint, int hHint) {
        GC gc = new GC((Drawable)this);
        if (this.fText == null || this.fText.isEmpty()) {
            Point e = gc.textExtent("A");
            return new Point(0, e.y + this.fMargin * 2);
        }
        Point e = gc.textExtent(this.fText);
        return new Point(e.x + this.fMargin * 2, e.y + this.fMargin * 2);
    }

    protected void onPaint(PaintEvent event) {
        GC gc = event.gc;
        Rectangle ca = this.getClientArea();
        Color mainColor = gc.getDevice().getSystemColor(26);
        gc.setBackground(mainColor);
        float[] mainHSB = mainColor.getRGB().getHSB();
        float h = mainHSB[0];
        float s = mainHSB[1];
        float b = mainHSB[2];
        Color borderColor = new Color(gc.getDevice(), new RGB(h, s, (float)((double)b * 0.7)));
        Color shadowColor = new Color(gc.getDevice(), new RGB(h, s, (float)((double)b * 0.5)));
        gc.setForeground(borderColor);
        gc.drawRectangle(0, 0, ca.width - 1, ca.height - 1);
        gc.setForeground(shadowColor);
        gc.drawLine(0, ca.height - 1, ca.width - 1, ca.height - 1);
        gc.fillRectangle(1, 1, ca.width - 2, ca.height - 2);
        gc.setForeground(gc.getDevice().getSystemColor(27));
        gc.drawText(this.fText, this.fMargin, this.fMargin, true);
        borderColor.dispose();
        shadowColor.dispose();
    }

    protected void onSelection(MouseEvent e) {
        if (this.isEnabled()) {
            this.notifyListeners(13, null);
        }
    }
}

