/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.jrebel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.jrebel.CFRebelConsoleUtil;
import org.eclipse.cft.server.core.internal.jrebel.CFRebelServerUrlHandler;
import org.eclipse.cft.server.core.internal.jrebel.JRebelIntegrationUtility;
import org.eclipse.cft.server.core.internal.jrebel.ReflectionHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.osgi.framework.Bundle;

public class CloudRebelServerUrlHandler
implements CFRebelServerUrlHandler {
    @Override
    public boolean updateUrls(CloudFoundryServer cloudServer, int eventType, IModule module, List<String> oldUrls, List<String> currentUrls, IProgressMonitor monitor) {
        ReflectionHandler reflectionHandler = JRebelIntegrationUtility.createReflectionHandler();
        return new ServerUrlReflectionHandler(module, cloudServer, oldUrls, currentUrls, reflectionHandler).doUrlUpdate();
    }

    public class ServerUrlReflectionHandler
    implements ReflectionHandler.ReflectionErrorHandler {
        private final IModule module;
        private final CloudFoundryServer cloudServer;
        private final List<String> oldUrls;
        private final List<String> currentUrls;
        private final ReflectionHandler reflectionHandler;

        public ServerUrlReflectionHandler(IModule module, CloudFoundryServer cloudServer, List<String> oldUrls, List<String> currentUrls, ReflectionHandler reflectionHandler) {
            Assert.isNotNull((Object)reflectionHandler, (String)"JRebel Cloud Foundry Tools Integration reflection handler cannot be null");
            this.module = module;
            this.cloudServer = cloudServer;
            this.oldUrls = oldUrls;
            this.currentUrls = currentUrls;
            this.reflectionHandler = reflectionHandler;
            this.reflectionHandler.addErrorHandler(this);
        }

        private boolean doReflectionUpdateUrls(Bundle bundle, Class<?> providerClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Method getRemotingProject = this.reflectionHandler.getRemotingProject(providerClass);
            if (getRemotingProject == null) {
                return false;
            }
            getRemotingProject.setAccessible(true);
            IProject project = this.module.getProject();
            Object remoteProjectObj = getRemotingProject.invoke(null, project);
            if (JRebelIntegrationUtility.isRemotingProject(remoteProjectObj)) {
                Class<?> integrationClass = this.reflectionHandler.getJRebelIntegration(bundle);
                if (integrationClass == null) {
                    return false;
                }
                this.removeUrls(integrationClass);
                this.addUrls(integrationClass);
                return true;
            }
            return false;
        }

        private void addUrls(Class<?> integrationClass) {
            Method addServerUrlsMethod;
            if (this.currentUrls != null && !this.currentUrls.isEmpty() && (addServerUrlsMethod = this.reflectionHandler.getAddServerUrlMethod(integrationClass)) != null) {
                HashMap<String, URI> serverUrls = new HashMap<String, URI>();
                for (String url : this.currentUrls) {
                    URI uri;
                    if (url == null || (uri = this.asUri(url)) == null) continue;
                    serverUrls.put(uri.toString(), uri);
                }
                this.reflectionHandler.addServerUrl(addServerUrlsMethod, serverUrls, () -> CFRebelConsoleUtil.printToConsole(this.module, this.cloudServer, NLS.bind((String)Messages.CFRebelServerIntegration_UPDATED_URL, this.currentUrls)));
            }
        }

        private void removeUrls(Class<?> integrationClass) {
            Method removeServerUrlsMethod;
            Collection<String> toRemove;
            if (this.oldUrls != null && !this.oldUrls.isEmpty() && !(toRemove = this.toRemove(this.oldUrls, this.currentUrls)).isEmpty() && (removeServerUrlsMethod = this.reflectionHandler.getRemoveServerUrlMethod(integrationClass)) != null) {
                ArrayList<URI> urisToRemove = new ArrayList<URI>();
                for (String url : toRemove) {
                    URI uri;
                    if (url == null || (uri = this.asUri(url)) == null) continue;
                    urisToRemove.add(uri);
                }
                this.reflectionHandler.removeServerUrl(removeServerUrlsMethod, urisToRemove, () -> CFRebelConsoleUtil.printToConsole(this.module, this.cloudServer, NLS.bind((String)Messages.CFRebelServerIntegration_REMOVED_URL, (Object)toRemove)));
            }
        }

        protected Collection<String> toRemove(List<String> old, List<String> current) {
            HashSet<String> toRemove = new HashSet<String>();
            if (old != null) {
                if (current == null) {
                    toRemove.addAll(old);
                } else {
                    for (String url : old) {
                        if (current.contains(url)) continue;
                        toRemove.add(url);
                    }
                }
            }
            return toRemove;
        }

        public boolean doUrlUpdate() {
            Bundle bundle = JRebelIntegrationUtility.getJRebelBundle();
            boolean updated = false;
            Exception error = null;
            if (bundle != null) {
                updated = true;
                try {
                    Class<?> providerClass = this.reflectionHandler.getRebelRemotingProvider(bundle);
                    if (providerClass != null) {
                        updated = this.doReflectionUpdateUrls(bundle, providerClass);
                    }
                }
                catch (SecurityException e) {
                    error = e;
                }
                catch (NoSuchMethodException e) {
                    error = e;
                }
                catch (IllegalAccessException e) {
                    error = e;
                }
                catch (InvocationTargetException e) {
                    error = e;
                }
                catch (IllegalArgumentException e) {
                    error = e;
                }
            }
            if (error != null) {
                CFRebelConsoleUtil.printErrorToConsole(this.module, this.cloudServer, error.getMessage());
                CloudFoundryPlugin.logError(error.getMessage(), error);
            }
            return updated;
        }

        protected URI asUri(String url) {
            URI uri = null;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                CloudFoundryPlugin.logError(e);
            }
            return uri;
        }

        @Override
        public void errorLoading(String memberId, String containerId, Throwable t) {
            String errorMessage = NLS.bind((String)Messages.CFRebelServerIntegration_ERROR_INCOMPATIBLE_JREBEL, (Object)memberId, (Object)containerId);
            CFRebelConsoleUtil.printErrorToConsole(this.module, this.cloudServer, errorMessage);
            CloudFoundryPlugin.logError(errorMessage, t);
        }
    }
}

