/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.dbgp.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.commands.IDbgpDataTypeCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.commands.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpDataTypeCommands
extends DbgpBaseCommands
implements IDbgpDataTypeCommands {
    private static final String TYPEMAP_GET_COMMAND = "typemap_get";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NAME = "name";
    private static final String TAG_MAP = "map";
    private final Map<String, Integer> converter = new HashMap<String, Integer>();

    private Integer typeToInteger(String type) {
        return this.converter.get(type);
    }

    public DbgpDataTypeCommands(IDbgpCommunicator communicator) {
        super(communicator);
        this.converter.put("bool", 0);
        this.converter.put("int", 1);
        this.converter.put("float", 2);
        this.converter.put("string", 3);
        this.converter.put("null", 4);
        this.converter.put("array", 5);
        this.converter.put("hash", 6);
        this.converter.put("object", 8);
        this.converter.put("resource", 9);
    }

    @Override
    public Map<String, Integer> getTypeMap() throws DbgpException {
        DbgpRequest request = DbgpDataTypeCommands.createRequest(TYPEMAP_GET_COMMAND);
        Element element = this.communicate(request);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        NodeList maps = element.getElementsByTagName(TAG_MAP);
        int i = 0;
        while (i < maps.getLength()) {
            Element map = (Element)maps.item(i);
            String type = map.getAttribute(ATTR_TYPE);
            Integer intType = this.typeToInteger(type);
            if (intType == null) {
                throw new DbgpException(Messages.DbgpDataTypeCommands_invalidTypeAttribute);
            }
            String name = map.getAttribute(ATTR_NAME);
            result.put(name, intType);
            ++i;
        }
        return result;
    }
}

