/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.compare;

import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.compare.CDOCompare;
import org.eclipse.emf.cdo.compare.CDOComparisonScope;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewOpener;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.scope.IComparisonScope;

public final class CDOCompareUtil {
    public static final CDOViewOpener DEFAULT_VIEW_OPENER = null;

    private CDOCompareUtil() {
    }

    public static Comparison compare(IComparisonScope scope) {
        return new CDOCompare().compare(scope);
    }

    public static Comparison compare(CDOObject left, CDOView rightView, CDOView[] originView) {
        return CDOCompareUtil.compare(left, rightView, originView, DEFAULT_VIEW_OPENER);
    }

    public static Comparison compare(CDOObject left, CDOView rightView, CDOView[] originView, CDOViewOpener viewOpener) {
        if (viewOpener == DEFAULT_VIEW_OPENER) {
            viewOpener = left.cdoView().getSession();
        }
        return CDOCompareUtil.compare((IComparisonScope)CDOComparisonScope.AllContents.create(left, rightView, originView, viewOpener));
    }

    public static Comparison compare(CDOView leftView, CDOView rightView, CDOView[] originView) {
        return CDOCompareUtil.compare(leftView, rightView, originView, DEFAULT_VIEW_OPENER);
    }

    public static Comparison compare(CDOView leftView, CDOView rightView, CDOView[] originView, CDOViewOpener viewOpener) {
        if (viewOpener == DEFAULT_VIEW_OPENER) {
            viewOpener = leftView.getSession();
        }
        return CDOCompareUtil.compare(CDOComparisonScope.Minimal.create(leftView, rightView, originView, viewOpener));
    }

    public static Comparison compare(CDOView leftView, CDOView rightView, CDOView[] originView, Set<CDOID> ids) {
        return CDOCompareUtil.compare(leftView, rightView, originView, ids, DEFAULT_VIEW_OPENER);
    }

    public static Comparison compare(CDOView leftView, CDOView rightView, CDOView[] originView, Set<CDOID> ids, CDOViewOpener viewOpener) {
        if (viewOpener == DEFAULT_VIEW_OPENER) {
            viewOpener = leftView.getSession();
        }
        return CDOCompareUtil.compare(CDOComparisonScope.Minimal.create(leftView, rightView, originView, ids, viewOpener));
    }

    public static Comparison compareUncommittedChanges(CDOTransaction transaction) {
        return CDOCompareUtil.compareUncommittedChanges(transaction, DEFAULT_VIEW_OPENER);
    }

    public static Comparison compareUncommittedChanges(CDOTransaction transaction, CDOViewOpener viewOpener) {
        if (viewOpener == DEFAULT_VIEW_OPENER) {
            viewOpener = transaction.getSession();
        }
        return CDOCompareUtil.compare(CDOComparisonScope.Minimal.create(transaction, viewOpener));
    }
}

