/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalCommitManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.ThreadPool;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class CommitManager
extends Lifecycle
implements InternalCommitManager {
    private InternalRepository repository;
    @ReflectUtil.ExcludeFromDump
    private transient ExecutorService executors;
    private boolean shutdownExecutorService;
    @ReflectUtil.ExcludeFromDump
    private transient Map<InternalTransaction, TransactionCommitContextEntry> contextEntries = new ConcurrentHashMap<InternalTransaction, TransactionCommitContextEntry>();

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(InternalRepository repository) {
        this.repository = repository;
    }

    public synchronized ExecutorService getExecutors() {
        if (this.executors == null) {
            this.executors = ConcurrencyUtil.getExecutorService((Object)this.repository);
            if (this.executors == null) {
                this.shutdownExecutorService = true;
                this.executors = ThreadPool.create();
            }
        }
        return this.executors;
    }

    public synchronized void setExecutors(ExecutorService executors) {
        if (this.shutdownExecutorService) {
            if (this.executors != null) {
                this.executors.shutdown();
            }
            this.shutdownExecutorService = false;
        }
        this.executors = executors;
    }

    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        this.setExecutors(null);
    }

    @Override
    @Deprecated
    public void preCommit(InternalCommitContext commitContext, OMMonitor monitor) {
        this.preCommit(commitContext, null, monitor);
    }

    @Override
    public void preCommit(InternalCommitContext commitContext, CDODataInput in, OMMonitor monitor) {
        TransactionCommitContextEntry contextEntry = new TransactionCommitContextEntry(in, monitor);
        contextEntry.setContext(commitContext);
        Future<Object> future = this.getExecutors().submit(contextEntry.createCallable());
        contextEntry.setFuture(future);
        this.contextEntries.put(commitContext.getTransaction(), contextEntry);
    }

    @Override
    public void remove(InternalCommitContext commitContext) {
        this.contextEntries.remove(commitContext.getTransaction());
    }

    @Override
    public void rollback(InternalCommitContext commitContext) {
        TransactionCommitContextEntry contextEntry = this.contextEntries.get(commitContext.getTransaction());
        if (contextEntry != null) {
            contextEntry.getFuture().cancel(true);
            commitContext.rollback("Remote rollback");
            commitContext.postCommit(false);
        }
    }

    @Override
    public void waitForTermination(InternalTransaction transaction) throws InterruptedException, ExecutionException {
        TransactionCommitContextEntry contextEntry = this.contextEntries.get(transaction);
        contextEntry.getFuture().get();
    }

    @Override
    public InternalCommitContext get(InternalTransaction transaction) {
        TransactionCommitContextEntry contextEntry = this.contextEntries.get(transaction);
        if (contextEntry != null) {
            return contextEntry.getContext();
        }
        return null;
    }

    private static final class TransactionCommitContextEntry {
        private final CDODataInput in;
        private final OMMonitor monitor;
        private InternalCommitContext context;
        private Future<Object> future;

        public TransactionCommitContextEntry(CDODataInput in, OMMonitor monitor) {
            this.in = in;
            this.monitor = monitor;
        }

        public Callable<Object> createCallable() {
            return new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        StoreThreadLocal.setCommitContext(context);
                        context.write(monitor);
                    }
                    finally {
                        StoreThreadLocal.setCommitContext(null);
                        if (in instanceof Closeable) {
                            IOUtil.closeSilent((Closeable)((Closeable)in));
                        }
                    }
                    return null;
                }
            };
        }

        public InternalCommitContext getContext() {
            return this.context;
        }

        public void setContext(InternalCommitContext context) {
            this.context = context;
        }

        public Future<Object> getFuture() {
            return this.future;
        }

        public void setFuture(Future<Object> future) {
            this.future = future;
        }
    }
}

