/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.bundle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.messages.Messages;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.IAppExtension;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiApplication;

public class CDOServerApplication
extends OSGiApplication {
    public static final String ID = "org.eclipse.emf.cdo.server.app";
    public static final String PROP_CONFIGURATOR_TYPE = "org.eclipse.emf.cdo.server.repositoryConfiguratorType";
    public static final String PROP_CONFIGURATOR_DESCRIPTION = "org.eclipse.emf.cdo.server.repositoryConfiguratorDescription";
    public static final String PROP_BROWSER_PORT = "org.eclipse.emf.cdo.server.browser.port";
    private IRepository[] repositories;
    private List<IAppExtension> extensions = new ArrayList<IAppExtension>();

    public CDOServerApplication() {
        super(ID);
    }

    protected RepositoryConfigurator getConfigurator(IManagedContainer container) {
        String type = OMPlatform.INSTANCE.getProperty(PROP_CONFIGURATOR_TYPE, "default");
        String description = OMPlatform.INSTANCE.getProperty(PROP_CONFIGURATOR_DESCRIPTION);
        return (RepositoryConfigurator)container.getElement("org.eclipse.emf.cdo.server.repositoryConfigurators", type, description);
    }

    protected IManagedContainer getApplicationContainer() {
        return CDOServerApplication.getContainer();
    }

    protected void doStart() throws Exception {
        super.doStart();
        IManagedContainer container = this.getApplicationContainer();
        OM.LOG.info(Messages.getString("CDOServerApplication.1"));
        File configFile = OMPlatform.INSTANCE.getConfigFile("cdo-server.xml");
        if (configFile != null && configFile.exists()) {
            String port;
            RepositoryConfigurator repositoryConfigurator = this.getConfigurator(container);
            this.repositories = repositoryConfigurator.configure(configFile);
            if (this.repositories == null || this.repositories.length == 0) {
                OM.LOG.warn(String.valueOf(Messages.getString("CDOServerApplication.3")) + " " + configFile.getAbsolutePath());
            }
            if ((port = OMPlatform.INSTANCE.getProperty(PROP_BROWSER_PORT)) != null) {
                container.getElement("org.eclipse.emf.cdo.server.browsers", "default", port);
            }
            this.startExtensions(configFile);
        } else {
            OM.LOG.warn(String.valueOf(Messages.getString("CDOServerApplication.5")) + " " + configFile.getAbsolutePath());
        }
        OM.LOG.info(Messages.getString("CDOServerApplication.6"));
    }

    protected void doStop() throws Exception {
        OM.LOG.info(Messages.getString("CDOServerApplication.7"));
        for (IAppExtension extension : this.extensions) {
            try {
                extension.stop();
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        if (this.repositories != null) {
            IRepository[] iRepositoryArray = this.repositories;
            int n = this.repositories.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository repository = iRepositoryArray[n2];
                LifecycleUtil.deactivate((Object)repository);
                ++n2;
            }
        }
        IManagedContainer container = this.getApplicationContainer();
        container.deactivate();
        OM.LOG.info(Messages.getString("CDOServerApplication.8"));
        super.doStop();
    }

    private void startExtensions(File configFile) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server", "appExtensions");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("appExtension".equals(element.getName())) {
                try {
                    IAppExtension extension = (IAppExtension)element.createExecutableExtension("class");
                    extension.start(configFile);
                    this.extensions.add(extension);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
    }

    public static IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }
}

