/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class ArtifactRepositoryTracker
extends RepositoryTracker {
    ProvisioningUI ui;

    public ArtifactRepositoryTracker(ProvisioningUI ui) {
        this.ui = ui;
    }

    public URI[] getKnownRepositories(ProvisioningSession session) {
        return this.getArtifactRepositoryManager().getKnownRepositories(this.getArtifactRepositoryFlags());
    }

    public void addRepository(URI repoLocation, String nickname, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            this.getArtifactRepositoryManager().addRepository(repoLocation);
            if (nickname != null) {
                this.getArtifactRepositoryManager().setRepositoryProperty(repoLocation, "p2.nickname", nickname);
            }
        }
        finally {
            this.ui.signalRepositoryOperationComplete(new RepositoryEvent(repoLocation, 1, 0, true), true);
        }
    }

    public void removeRepositories(URI[] repoLocations, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            URI[] uRIArray = repoLocations;
            int n = repoLocations.length;
            int n2 = 0;
            while (n2 < n) {
                URI repoLocation = uRIArray[n2];
                this.getArtifactRepositoryManager().removeRepository(repoLocation);
                ++n2;
            }
        }
        finally {
            this.ui.signalRepositoryOperationComplete(null, true);
        }
    }

    public void refreshRepositories(URI[] locations, ProvisioningSession session, IProgressMonitor monitor) {
        this.ui.signalRepositoryOperationStart();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(locations.length * 100));
        URI[] uRIArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            URI location = uRIArray[n2];
            try {
                this.getArtifactRepositoryManager().refreshRepository(location, (IProgressMonitor)mon.newChild(100));
            }
            catch (ProvisionException provisionException) {}
            ++n2;
        }
        this.ui.signalRepositoryOperationComplete(null, true);
    }

    IArtifactRepositoryManager getArtifactRepositoryManager() {
        return ProvUI.getArtifactRepositoryManager((ProvisioningSession)this.ui.getSession());
    }

    protected boolean contains(URI location, ProvisioningSession session) {
        return ProvUI.getArtifactRepositoryManager((ProvisioningSession)session).contains(location);
    }
}

