/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ListValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;

public class CalloutMappingsAttribute
extends ListValueAttribute {
    RoleModel _role;
    private CallinCalloutBinding[] _mappings;
    private char[][] _methodNames = null;
    private char[][] _methodSignatures = null;
    private char[][] _baseMethodNames = null;
    private char[][] _baseMethodSignatures = null;
    private byte[] _flags = null;
    public static final byte CALLOUT_GET = 1;
    public static final byte CALLOUT_SET = 2;
    private static final byte CALLOUT_PUBLIC = 4;
    private static final byte CALLOUT_PROTECTED = 8;
    private static final byte CALLOUT_PRIVATE = 16;
    private static final int ELEMENT_LENGTH = 11;

    public CalloutMappingsAttribute(RoleModel role) {
        super(IOTConstants.CALLOUT_MAPPINGS, 0, 11);
        this._role = role;
    }

    public CalloutMappingsAttribute(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        super(IOTConstants.CALLOUT_MAPPINGS, 0, 11);
        this.readList(reader, readOffset, 0, constantPoolOffsets);
    }

    public int getNumMappings() {
        return this._methodNames.length;
    }

    public String getRoleMethodNameAt(int i) {
        return String.valueOf(this._methodNames[i]);
    }

    public String getRoleMethodSignatureAt(int i) {
        return String.valueOf(this._methodSignatures[i]);
    }

    public String getBaseMethodNameAt(int i) {
        return String.valueOf(this._baseMethodNames[i]);
    }

    public String getBaseMethodSignatureAt(int i) {
        return String.valueOf(this._baseMethodSignatures[i]);
    }

    public int getCalloutFlagsAt(int i) {
        return this._flags[i] & 3;
    }

    public int getDeclaredModifiersAt(int i) {
        switch (this._flags[i] & 0x1C) {
            case 4: {
                return 1;
            }
            case 8: {
                return 4;
            }
            case 16: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    void read(int i) {
        if (this._methodNames == null) {
            this._methodNames = new char[this._count][];
            this._methodSignatures = new char[this._count][];
            this._flags = new byte[this._count];
            this._baseMethodNames = new char[this._count][];
            this._baseMethodSignatures = new char[this._count][];
        }
        this._methodNames[i] = this.consumeName();
        this._methodSignatures[i] = this.consumeName();
        this._flags[i] = (byte)this.consumeByte();
        this.consumeName();
        this._baseMethodNames[i] = this.consumeName();
        this._baseMethodSignatures[i] = this.consumeName();
    }

    @Override
    public boolean setupForWriting() {
        if (this._role.isIgnoreFurtherInvestigation()) {
            return false;
        }
        this._mappings = this._role.getBinding().callinCallouts;
        this._count = this.filterGoodBindings();
        return this._count > 0;
    }

    private int filterGoodBindings() {
        int i = 0;
        int j = 0;
        while (j < this._mappings.length) {
            this._mappings[i] = this._mappings[j];
            CallinCalloutBinding currenMapping = this._mappings[j];
            if (currenMapping.isCallout() && (currenMapping.tagBits & Long.MIN_VALUE) == 0L && currenMapping.hasValidRoleMethod() && currenMapping.hasValidBaseMethods()) {
                ++i;
            }
            ++j;
        }
        return i;
    }

    @Override
    void writeElementValue(int i) {
        CallinCalloutBinding mapping = this._mappings[i];
        this.writeName(mapping._roleMethodBinding.constantPoolName());
        this.writeName(mapping._roleMethodBinding.signature());
        byte flags = 0;
        switch (mapping.calloutModifier) {
            case 142: {
                flags = 1;
                break;
            }
            case 143: {
                flags = 2;
            }
        }
        switch (mapping.declaredModifiers) {
            case 1: {
                flags = (byte)(flags | 4);
                break;
            }
            case 4: {
                flags = (byte)(flags | 8);
                break;
            }
            case 2: {
                flags = (byte)(flags | 0x10);
            }
        }
        this.writeByte(flags);
        MethodBinding baseMethod = mapping._baseMethods[0];
        this.writeName(baseMethod.declaringClass.attributeName());
        this.writeName(baseMethod.constantPoolName());
        this.writeName(baseMethod.signature());
    }

    @Override
    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        this.checkBindingMismatch(binding, 65536);
        ((ReferenceBinding)binding).roleModel.addAttribute(this);
    }

    @Override
    public void evaluateLateAttribute(ReferenceBinding type, int state) {
        if (state != 13) {
            return;
        }
        this._mappings = new CallinCalloutBinding[this._count];
        if (this._count == 0) {
            return;
        }
        int i = 0;
        while (i < this._methodNames.length) {
            int calloutModifiers;
            int j;
            MethodBinding[] methods;
            block9: {
                char[] methodName = this._methodNames[i];
                methods = null;
                ReferenceBinding site = type;
                while (site != null) {
                    methods = site.getMethods(methodName);
                    j = 0;
                    while (j < methods.length) {
                        if (this.methodMatchesSignature(methods[j], this._methodSignatures[i])) {
                            calloutModifiers = 0;
                            if ((this._flags[i] & 1) != 0) {
                                calloutModifiers = 142;
                            } else if ((this._flags[i] & 2) != 0) {
                                calloutModifiers = 143;
                            }
                            break block9;
                        }
                        ++j;
                    }
                    site = site.superclass();
                }
                throw new InternalCompilerError("callout binding refers to inexistent role method: " + new String(this._methodNames[i]) + new String(this._methodSignatures[i]));
            }
            int declaredModifiers = this.getDeclaredModifiersAt(i);
            this._mappings[i] = new CallinCalloutBinding(false, methods[j], type, calloutModifiers, declaredModifiers);
            ++i;
        }
        type.addCallinCallouts(this._mappings);
    }

    private boolean methodMatchesSignature(MethodBinding methodBinding, char[] signature) {
        if (CharOperation.equals(methodBinding.signature(), signature)) {
            return true;
        }
        TypeBinding type = methodBinding.returnType;
        char[][] signatureTypes = CalloutMappingsAttribute.scanSignature(signature);
        if (!this.typeMatchesSignature(type, signatureTypes[0])) {
            return false;
        }
        char[][] types = CharOperation.subarray(signatureTypes, 1, -1);
        if (types.length != methodBinding.parameters.length) {
            return false;
        }
        int i = 0;
        while (i < types.length) {
            if (!this.typeMatchesSignature(methodBinding.parameters[i], types[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean typeMatchesSignature(TypeBinding type, char[] signature) {
        char[] bindingType;
        char[] signatureType = signature;
        if (!type.isValidBinding()) {
            signatureType = this.getSignatureSimpleName(signatureType);
            bindingType = type.internalName();
        } else {
            bindingType = type.signature();
        }
        return CharOperation.equals(bindingType, signatureType);
    }

    private char[] getSignatureSimpleName(char[] signatureType) {
        if (signatureType[signatureType.length - 1] != ';') {
            return signatureType;
        }
        int start = CharOperation.lastIndexOf('/', signatureType);
        if (start == -1) {
            start = 0;
        }
        return CharOperation.subarray(signatureType, start + 1, signatureType.length - 1);
    }

    public static char[][] scanSignature(char[] methodDescriptor) throws IllegalArgumentException {
        char nextChar;
        int numOfParams = 0;
        int index = 0;
        while ((nextChar = methodDescriptor[++index]) != ')') {
            if (nextChar == '[') continue;
            ++numOfParams;
            if (nextChar != 'L') continue;
            while ((nextChar = methodDescriptor[++index]) != ';') {
            }
        }
        int startIndex = 0;
        int size = numOfParams - startIndex;
        char[][] result = new char[size + 1][];
        if (size > 0) {
            index = 1;
            int end = 0;
            int i = 0;
            while (i < numOfParams) {
                while ((nextChar = methodDescriptor[++end]) == '[') {
                }
                if (nextChar == 'L') {
                    while ((nextChar = methodDescriptor[++end]) != ';') {
                    }
                }
                if (i >= startIndex) {
                    result[i - startIndex + 1] = CharOperation.subarray(methodDescriptor, index, end + 1);
                }
                index = end + 1;
                ++i;
            }
        }
        result[0] = CharOperation.subarray(methodDescriptor, index + 1, -1);
        return result;
    }

    @Override
    String toString(int i) {
        if (this._mappings != null) {
            return this._mappings[i].toString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this._methodNames[i]);
        buf.append(this._methodSignatures[i]);
        buf.append(" -> ");
        if ((this._flags[i] & 1) != 0) {
            buf.append("get ");
        }
        if ((this._flags[i] & 2) != 0) {
            buf.append("set ");
        }
        buf.append(this._baseMethodNames[i]);
        buf.append(this._baseMethodSignatures[i]);
        return buf.toString();
    }
}

