/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.weave;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jpt.common.core.internal.gen.AbstractJptGenerator;
import org.eclipse.jpt.common.utility.internal.StringTools;

public class EclipseLinkStaticWeave
extends AbstractJptGenerator {
    public static String LAUNCH_CONFIG_NAME = "Static Weaving Run Config";
    public static String WEAVING_PACKAGE_NAME = "org.eclipse.persistence.tools.weaving.jpa";
    public static String WEAVING_CLASS = String.valueOf(WEAVING_PACKAGE_NAME) + ".StaticWeave";
    private String source;
    private String target;
    private String loglevel;
    private String persistenceinfo;
    private final String mainType;

    public EclipseLinkStaticWeave(IJavaProject javaProject, String source, String target, String loglevel, String persistenceinfo) {
        super(javaProject);
        this.source = source;
        this.target = target;
        this.loglevel = loglevel;
        this.persistenceinfo = persistenceinfo;
        this.mainType = WEAVING_CLASS;
    }

    protected String getMainType() {
        return this.mainType;
    }

    protected String getLaunchConfigName() {
        return LAUNCH_CONFIG_NAME;
    }

    protected void specifyJRE() {
    }

    protected void preGenerate(IProgressMonitor monitor) {
    }

    protected List<String> buildClasspath() throws CoreException {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(this.getDefaultProjectClasspathEntry().getMemento());
        classpath.add(this.getSystemLibraryClasspathEntry().getMemento());
        for (IRuntimeClasspathEntry containerClasspathEntry : this.getContainersClasspathEntries()) {
            classpath.add(containerClasspathEntry.getMemento());
        }
        return classpath;
    }

    protected void specifyProgramArguments() {
        StringBuffer programArguments = new StringBuffer();
        if (StringTools.isBlank((String)this.source)) {
            throw new RuntimeException("Source directory cannot be empty");
        }
        if (StringTools.isBlank((String)this.target)) {
            throw new RuntimeException("Target directory cannot be empty");
        }
        if (!StringTools.isBlank((String)this.loglevel)) {
            programArguments.append("-loglevel ");
            programArguments.append(this.loglevel);
        }
        if (!StringTools.isBlank((String)this.persistenceinfo)) {
            programArguments.append(" -persistenceinfo ");
            programArguments.append(StringTools.quote((String)this.persistenceinfo));
        }
        programArguments.append(' ');
        programArguments.append(StringTools.quote((String)this.source));
        programArguments.append(' ');
        programArguments.append(StringTools.quote((String)this.target));
        this.getLaunchConfig().setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
    }

    private List<IRuntimeClasspathEntry> getContainersClasspathEntries() throws CoreException {
        ArrayList<IRuntimeClasspathEntry> classpathEntries = new ArrayList<IRuntimeClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = this.getJavaProject().getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathContainer container;
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getEntryKind() == 5 && (container = JavaCore.getClasspathContainer((IPath)classpathEntry.getPath(), (IJavaProject)this.getJavaProject())) != null && container.getKind() == 2) {
                classpathEntries.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)container.getPath(), (int)2, (IJavaProject)this.getJavaProject()));
            }
            ++n2;
        }
        return classpathEntries;
    }
}

