/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class LSPRenameProcessor
extends RefactoringProcessor {
    private static final String ID = "org.eclipse.lsp4e.operations.rename";
    private final IDocument document;
    private final LanguageServer languageServer;
    private final int offset;
    private String newName;
    private WorkspaceEdit rename;
    private Either<Range, PrepareRenameResult> prepareRenameResult;

    public LSPRenameProcessor(@NonNull IDocument document, LanguageServer languageServer, int offset) {
        this.document = document;
        this.languageServer = languageServer;
        this.offset = offset;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return ID;
    }

    public String getProcessorName() {
        return Messages.rename_processor_name;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.document == null) {
            return status;
        }
        try {
            CompletableFuture<List<LanguageServer>> serverList = LanguageServiceAccessor.getLanguageServers(this.document, LSPRenameProcessor::isPrepareRenameProvider);
            for (LanguageServer serverToTry : serverList.get(500L, TimeUnit.MILLISECONDS)) {
                if (!this.languageServer.equals(serverToTry)) continue;
                TextDocumentIdentifier identifier = new TextDocumentIdentifier(LSPEclipseUtils.toUri(this.document).toString());
                PrepareRenameParams params = new PrepareRenameParams();
                params.setTextDocument(identifier);
                params.setPosition(LSPEclipseUtils.toPosition(this.offset, this.document));
                this.prepareRenameResult = (Either)this.languageServer.getTextDocumentService().prepareRename(params).get(1000L, TimeUnit.MILLISECONDS);
                if (this.prepareRenameResult != null) continue;
                status.addFatalError(Messages.rename_invalidated);
            }
        }
        catch (Exception e) {
            this.handleError(e, status);
            return new RefactoringStatus();
        }
        return status;
    }

    public String getPlaceholder() {
        if (this.prepareRenameResult != null) {
            if (this.prepareRenameResult.isRight()) {
                return ((PrepareRenameResult)this.prepareRenameResult.getRight()).getPlaceholder();
            }
            Range range = (Range)this.prepareRenameResult.getLeft();
            try {
                int startOffset = LSPEclipseUtils.toOffset(range.getStart(), this.document);
                int endOffset = LSPEclipseUtils.toOffset(range.getEnd(), this.document);
                return this.document.get(startOffset, endOffset - startOffset);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return "newName";
    }

    public static boolean isPrepareRenameProvider(ServerCapabilities serverCapabilities) {
        if (serverCapabilities == null) {
            return false;
        }
        Either renameProvider = serverCapabilities.getRenameProvider();
        if (renameProvider == null) {
            return false;
        }
        if (renameProvider.isRight()) {
            return renameProvider.getRight() != null && ((RenameOptions)renameProvider.getRight()).getPrepareProvider() != false;
        }
        return false;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            RenameParams params = new RenameParams();
            params.setPosition(LSPEclipseUtils.toPosition(this.offset, this.document));
            TextDocumentIdentifier identifier = new TextDocumentIdentifier();
            identifier.setUri(LSPEclipseUtils.toUri(this.document).toString());
            params.setTextDocument(identifier);
            params.setNewName(this.newName);
            if (params.getNewName() != null) {
                this.rename = (WorkspaceEdit)this.languageServer.getTextDocumentService().rename(params).get(1000L, TimeUnit.MILLISECONDS);
                if (!status.hasError() && this.rename.getChanges().isEmpty()) {
                    status.addWarning(Messages.rename_empty_message);
                }
            }
        }
        catch (Exception e) {
            this.handleError(e, status);
        }
        return status;
    }

    private WorkspaceEdit handleError(Throwable e, RefactoringStatus status) {
        if (e.getCause() instanceof ResponseErrorException) {
            ResponseError responseError = ((ResponseErrorException)e.getCause()).getResponseError();
            String message = String.valueOf(responseError.getMessage()) + (responseError.getData() instanceof String ? ": " + responseError.getData() : "");
            status.addFatalError(message);
        } else {
            status.addFatalError(e.getMessage());
        }
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.rename == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e", Messages.rename_processor_required));
        }
        return LSPEclipseUtils.toCompositeChange(this.rename);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return null;
    }

    public void setNewName(String newName) {
        Assert.isNotNull((Object)newName);
        this.newName = newName;
    }
}

