/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.signal.Request;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class MonitorProgressRequest
extends Request {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SIGNAL, MonitorProgressRequest.class);
    private int correlationID;
    private double totalWork;
    private double work;

    public MonitorProgressRequest(SignalProtocol<?> protocol, int correlationID, double totalWork, double work) {
        super(protocol, (short)-3);
        this.correlationID = correlationID;
        this.totalWork = totalWork;
        this.work = work;
    }

    @Override
    protected void requesting(ExtendedDataOutputStream out) throws Exception {
        if (TRACER.isEnabled()) {
            TRACER.format("Progress of signal {0}: totalWork={1}, work={2}", new Object[]{this.correlationID, this.totalWork, this.work});
        }
        out.writeInt(this.correlationID);
        out.writeDouble(this.totalWork);
        out.writeDouble(this.work);
    }
}

