/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.impl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.targlets.PluginGenerator;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.targlets.util.VersionGenerator;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginGeneratorImpl
extends ModelElementImpl
implements PluginGenerator {
    private static final IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");

    protected PluginGeneratorImpl() {
    }

    protected EClass eStaticClass() {
        return TargletPackage.Literals.PLUGIN_GENERATOR;
    }

    @Override
    public void generateIUs(IProject project, final String qualifierReplacement, final Map<String, Version> iuVersions, final EList<IInstallableUnit> result) throws Exception {
        ResourcesUtil.runWithFile((IProject)project, (IPath)MANIFEST_PATH, (ResourcesUtil.RunnableWithFile)new ResourcesUtil.RunnableWithFile(){

            public void run(File projectFolder, File file) throws Exception {
                BundleGeneratorAction action = new BundleGeneratorAction();
                action.generateIUs(projectFolder, qualifierReplacement, iuVersions, (EList<IInstallableUnit>)result);
            }
        });
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                try {
                    this.generateIUs((IProject)arguments.get(0), (String)arguments.get(1), (Map)arguments.get(2), (EList<IInstallableUnit>)((EList)arguments.get(3)));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BundleGeneratorAction
    extends BundlesAction {
        public BundleGeneratorAction() {
            super(null);
            this.setPublisherInfo((IPublisherInfo)new PublisherInfo());
        }

        public void generateIUs(File projectFolder, String qualifierReplacement, Map<String, Version> ius, EList<IInstallableUnit> result) throws Exception {
            Dictionary manifest = BundleGeneratorAction.loadManifest((File)projectFolder);
            if (manifest == null) {
                return;
            }
            String version = (String)manifest.get("Bundle-Version");
            manifest.put("Bundle-Version", VersionGenerator.replaceQualifier(version, qualifierReplacement));
            BundleDescription description = BundleGeneratorAction.createBundleDescription((Dictionary)manifest, (File)projectFolder);
            if (description == null) {
                return;
            }
            this.createAdviceFileAdvice(description, this.info);
            IInstallableUnit iu = BundleGeneratorAction.createBundleIU((BundleDescription)description, null, (IPublisherInfo)this.info);
            if (iu instanceof InstallableUnit) {
                Map properties;
                String additionalBundles;
                File buildPropertiesFile;
                InstallableUnit installableUnit = (InstallableUnit)iu;
                installableUnit.setArtifacts(new IArtifactKey[0]);
                ArrayList requirements = new ArrayList(iu.getRequirements());
                boolean relaxed = false;
                ListIterator<IRequirement> it = requirements.listIterator();
                while (it.hasNext()) {
                    IRequirement requirement = (IRequirement)it.next();
                    if (P2Util.isSimpleRequiredCapability((IRequirement)requirement)) continue;
                    try {
                        it.set(MetadataFactory.createRequirement((IMatchExpression)requirement.getMatches(), (IMatchExpression)requirement.getFilter(), (int)0, (int)requirement.getMax(), (boolean)true));
                        relaxed = true;
                    }
                    catch (RuntimeException runtimeException) {}
                }
                if (relaxed) {
                    installableUnit.setRequiredCapabilities(requirements.toArray(new IRequirement[requirements.size()]));
                }
                if ((buildPropertiesFile = new File(projectFolder, "build.properties")).exists() && (additionalBundles = (String)(properties = PropertiesUtil.loadProperties((File)buildPropertiesFile)).get("additional.bundles")) != null) {
                    ArrayList<IRequirement> additionalRequirements = new ArrayList<IRequirement>();
                    String[] stringArray = additionalBundles.trim().split("\\s*,\\s*");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String bundle = stringArray[n2];
                        additionalRequirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)bundle, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true));
                        ++n2;
                    }
                    if (!additionalRequirements.isEmpty()) {
                        additionalRequirements.addAll(0, installableUnit.getRequirements());
                        installableUnit.setRequiredCapabilities(additionalRequirements.toArray(new IRequirement[additionalRequirements.size()]));
                    }
                }
            }
            result.add((Object)iu);
            MetadataFactory.InstallableUnitDescription[] otherDescriptions = BundleGeneratorAction.processAdditionalInstallableUnitsAdvice((IInstallableUnit)iu, (IPublisherInfo)this.info);
            if (otherDescriptions != null) {
                MetadataFactory.InstallableUnitDescription[] installableUnitDescriptionArray = otherDescriptions;
                int n = otherDescriptions.length;
                int n3 = 0;
                while (n3 < n) {
                    MetadataFactory.InstallableUnitDescription otherDescription = installableUnitDescriptionArray[n3];
                    IInstallableUnit otherIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)otherDescription);
                    result.add((Object)otherIU);
                    ++n3;
                }
            }
        }
    }
}

