/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.nattable.sorting;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;

public class EventListObservableAdapter<E>
extends AbstractEventList<E> {
    private final IChangeListener elementListener;
    private final IListChangeListener<E> listener;
    private IObservableList<E> delegate;

    public EventListObservableAdapter() {
        this(null);
    }

    public EventListObservableAdapter(ListEventPublisher publisher) {
        super(publisher);
        this.readWriteLock = LockFactory.DEFAULT.createReadWriteLock();
        this.listener = new IListChangeListener<E>(){

            public void handleListChange(ListChangeEvent<? extends E> event) {
                EventListObservableAdapter.this.readWriteLock.readLock().lock();
                try {
                    EventListObservableAdapter.this.updates.beginEvent();
                    try {
                        Stream.of(event.diff.getDifferences()).forEach(entry -> {
                            if (entry.isAddition()) {
                                EventListObservableAdapter.this.updates.elementInserted(entry.getPosition(), entry.getElement());
                                EventListObservableAdapter.this.connect(entry.getElement());
                            } else {
                                EventListObservableAdapter.this.disconnect(entry.getElement());
                                EventListObservableAdapter.this.updates.elementDeleted(entry.getPosition(), entry.getElement());
                            }
                        });
                    }
                    finally {
                        EventListObservableAdapter.this.updates.commitEvent();
                    }
                }
                finally {
                    EventListObservableAdapter.this.readWriteLock.readLock().unlock();
                }
            }
        };
        this.elementListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                EventListObservableAdapter.this.readWriteLock.readLock().lock();
                try {
                    EventListObservableAdapter.this.updates.beginEvent();
                    try {
                        IObservable element = event.getObservable();
                        EventListObservableAdapter.this.updates.elementUpdated(EventListObservableAdapter.this.indexOf(element), (Object)element, (Object)element);
                    }
                    finally {
                        EventListObservableAdapter.this.updates.commitEvent();
                    }
                }
                finally {
                    EventListObservableAdapter.this.readWriteLock.readLock().unlock();
                }
            }
        };
    }

    public synchronized void setDelegate(IObservableList<E> newDelegate) {
        IObservableList<E> oldDelegate = this.delegate;
        this.delegate = newDelegate;
        if (oldDelegate != null) {
            oldDelegate.removeListChangeListener(this.listener);
        }
        if (newDelegate != null) {
            newDelegate.addListChangeListener(this.listener);
        }
        this.readWriteLock.readLock().lock();
        try {
            this.updates.beginEvent();
            try {
                AtomicInteger i = new AtomicInteger();
                if (oldDelegate != null) {
                    oldDelegate.subList(0, newDelegate == null ? 0 : newDelegate.size()).forEach(e -> {
                        Object newE = newDelegate.get(i.get());
                        this.disconnect(e);
                        this.updates.elementUpdated(i.getAndIncrement(), e, newE);
                        this.connect(newE);
                    });
                    if (oldDelegate.size() < i.get()) {
                        oldDelegate.forEach(e -> {
                            this.disconnect(e);
                            this.updates.elementDeleted(i.getAndIncrement(), e);
                        });
                    }
                }
                if (newDelegate != null && newDelegate.size() > i.get()) {
                    newDelegate.listIterator(i.get()).forEachRemaining(e -> {
                        this.updates.elementInserted(i.getAndIncrement(), e);
                        this.connect(e);
                    });
                }
            }
            finally {
                this.updates.commitEvent();
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.removeListChangeListener(this.listener);
        }
    }

    public int size() {
        return this.delegate == null ? 0 : this.delegate.size();
    }

    public E get(int index) {
        this.checkDelegate();
        return (E)this.delegate.get(index);
    }

    private void checkDelegate() {
        if (this.delegate == null) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void add(int index, E value) {
        this.checkDelegate();
        this.delegate.add(index, value);
    }

    public E set(int index, E value) {
        this.checkDelegate();
        return (E)this.delegate.set(index, value);
    }

    public E remove(int index) {
        this.checkDelegate();
        return (E)this.delegate.remove(index);
    }

    private void connect(E newElement) {
        if (newElement instanceof IObservable) {
            ((IObservable)newElement).addChangeListener(this.elementListener);
        }
    }

    private void disconnect(E newElement) {
        if (newElement instanceof IObservable) {
            ((IObservable)newElement).removeChangeListener(this.elementListener);
        }
    }
}

