/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public class CustomSetConnectionBendpointsCommand
extends AbstractTransactionalCommand {
    private IAdaptable edgeAdaptor;
    private ReconnectRequest request;
    private INodeEditPart node;

    public CustomSetConnectionBendpointsCommand(TransactionalEditingDomain editingDomain) {
        super(editingDomain, DiagramUIMessages.Commands_SetBendpointsCommand_Label, null);
    }

    public List<?> getAffectedFiles() {
        View view = (View)this.edgeAdaptor.getAdapter(View.class);
        if (view != null) {
            return CustomSetConnectionBendpointsCommand.getWorkspaceFiles((EObject)view);
        }
        return super.getAffectedFiles();
    }

    public IAdaptable getEdgeAdaptor() {
        return this.edgeAdaptor;
    }

    public void setEdgeAdaptor(IAdaptable edgeAdapter) {
        this.edgeAdaptor = edgeAdapter;
    }

    public ReconnectRequest getRequest() {
        return this.request;
    }

    public void setRequest(ReconnectRequest request) {
        this.request = request;
    }

    public INodeEditPart getNode() {
        return this.node;
    }

    public void setNode(INodeEditPart node) {
        this.node = node;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull((Object)this.request);
        Edge edge = (Edge)this.getEdgeAdaptor().getAdapter(Edge.class);
        Assert.isNotNull((Object)edge);
        ConnectionAnchor sourceAnchor = this.node.getSourceConnectionAnchor((Request)this.request);
        ConnectionAnchor targetAnchor = this.node.getTargetConnectionAnchor((Request)this.request);
        Point sourceRefPoint = sourceAnchor.getReferencePoint();
        Point targetRefPoint = targetAnchor.getReferencePoint();
        PointList pointList = new PointList();
        pointList.addPoint(sourceAnchor.getLocation(targetRefPoint));
        pointList.addPoint(targetAnchor.getLocation(sourceRefPoint));
        ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < pointList.size()) {
            Dimension s = pointList.getPoint(i).getDifference(sourceRefPoint);
            Dimension t = pointList.getPoint(i).getDifference(targetRefPoint);
            newBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
            i = (short)(i + 1);
        }
        RelativeBendpoints points = (RelativeBendpoints)edge.getBendpoints();
        points.setPoints(newBendpoints);
        return CommandResult.newOKCommandResult();
    }
}

