/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SemanticCreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.helper.advice.InteractionContainerDeletionContext;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.UMLPackage;

public class InteractionFragmentContainerCreationEditPolicy
extends DefaultCreationEditPolicy {
    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        IEditCommandRequest semanticCreateRequest;
        IElementType typeToCreate = (IElementType)request.getViewAndElementDescriptor().getElementAdapter().getAdapter(IElementType.class);
        if (!ElementUtil.isTypeOf((IElementType)typeToCreate, (IElementType)UMLElementTypes.LIFELINE) && (semanticCreateRequest = (IEditCommandRequest)request.getViewAndElementDescriptor().getCreateElementRequestAdapter().getAdapter(IEditCommandRequest.class)) != null) {
            Rectangle rectangle = this.getCreationRectangle(request);
            Set<Lifeline> covered = SequenceUtil.getCoveredLifelines(rectangle, this.getHost());
            RequestParameterUtils.setCoveredLifelines((IEditCommandRequest)semanticCreateRequest, covered);
        }
        if (ElementUtil.isTypeOf((IElementType)typeToCreate, (IElementType)UMLElementTypes.COMBINED_FRAGMENT)) {
            return this.getCreateElementAndViewCommandForCombinedFragmentWithUndo(request);
        }
        return super.getCreateElementAndViewCommand(request);
    }

    private Command getCreateElementAndViewCommandForCombinedFragmentWithUndo(final CreateViewAndElementRequest request) {
        final TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Command undoCommand = new Command(){
            private CombinedFragment createdCombinedFragment = null;
            private EObject container = null;
            private EStructuralFeature feature = null;

            public void undo() {
                final CombinedFragment combinedFragment = InteractionFragmentContainerCreationEditPolicy.this.getCombinedFragment(request.getNewObject());
                if (combinedFragment != null) {
                    this.createdCombinedFragment = combinedFragment;
                    InteractionOperand interactionOperand = (InteractionOperand)combinedFragment.getOperands().get(0);
                    CompositeCommand compositeCommand = new CompositeCommand("Move needed fragments");
                    for (InteractionFragment interactionFragment : interactionOperand.getFragments()) {
                        DestroyElementRequest request2 = new DestroyElementRequest(editingDomain, (EObject)interactionOperand, false);
                        Optional context = InteractionContainerDeletionContext.get((DestroyElementRequest)request2);
                        Optional<ICommand> result = context.map(ctx -> ctx.getDestroyCommand(interactionFragment));
                        ICommand undoCommand = result.get();
                        if (undoCommand == null || !undoCommand.canExecute()) continue;
                        compositeCommand.add((IUndoableOperation)undoCommand);
                    }
                    if (compositeCommand != null && !compositeCommand.isEmpty() && compositeCommand.canExecute()) {
                        try {
                            compositeCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                        }
                        catch (ExecutionException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                    this.container = combinedFragment.eContainer();
                    this.feature = this.container instanceof Interaction ? UMLPackage.eINSTANCE.getInteraction_Fragment() : (this.container instanceof InteractionOperand ? UMLPackage.eINSTANCE.getInteractionOperand_Fragment() : null);
                    AbstractTransactionalCommand abstractTransactionalCommand = new AbstractTransactionalCommand(editingDomain, "Remove CombinedFragment", Collections.singletonList(combinedFragment.eResource())){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            Object value = container.eGet(feature);
                            if (value instanceof List) {
                                ((List)value).remove(combinedFragment);
                            }
                            return CommandResult.newOKCommandResult();
                        }
                    };
                    try {
                        abstractTransactionalCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                    }
                    catch (ExecutionException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }

            public void redo() {
                AbstractTransactionalCommand abstractTransactionalCommand = new AbstractTransactionalCommand(editingDomain, "Remove CombinedFragment", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        Object value;
                        if (container != null && feature != null && createdCombinedFragment != null && (value = container.eGet(feature)) instanceof List) {
                            ((List)value).add(createdCombinedFragment);
                        }
                        return CommandResult.newOKCommandResult();
                    }
                };
                try {
                    abstractTransactionalCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        };
        return undoCommand.chain(this.getCreateElementAndViewCommandForCombinedFragment(request));
    }

    private Command getCreateElementAndViewCommandForCombinedFragment(CreateViewAndElementRequest request) {
        Command createElementCommand;
        CreateElementRequestAdapter requestAdapter = request.getViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateElementRequest createElementRequest = (CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class);
        if (createElementRequest.getContainer() == null) {
            View view = (View)this.getHost().getModel();
            EObject hostElement = ViewUtil.resolveSemanticElement((View)view);
            if (hostElement == null && view.getElement() == null) {
                hostElement = view;
            }
            if (hostElement == null) {
                return null;
            }
            createElementRequest.setContainer(hostElement);
        }
        if ((createElementCommand = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)((CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class)), request.getExtendedData()))) == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!createElementCommand.canExecute()) {
            return createElementCommand;
        }
        SemanticCreateCommand semanticCommand = new SemanticCreateCommand(requestAdapter, createElementCommand){

            protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return CommandResult.newOKCommandResult();
            }

            protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return CommandResult.newOKCommandResult();
            }
        };
        Command viewCommand = this.getCreateCommand((CreateViewRequest)request);
        Command refreshConnectionCommand = this.getHost().getCommand((Request)new RefreshConnectionsRequest((List)request.getNewObject()));
        CompositeCommand cc = new CompositeCommand(semanticCommand.getLabel());
        cc.compose((IUndoableOperation)semanticCommand);
        cc.compose((IUndoableOperation)new CommandProxy(viewCommand));
        if (refreshConnectionCommand != null) {
            cc.compose((IUndoableOperation)new CommandProxy(refreshConnectionCommand));
        }
        return new ICommandProxy((ICommand)cc);
    }

    private CombinedFragment getCombinedFragment(Object newObject) {
        EObject eObject;
        CreateElementRequest createElementRequest;
        CombinedFragment result = null;
        if (newObject instanceof Collection) {
            Iterator collectionIt = ((Collection)newObject).iterator();
            while (collectionIt.hasNext() && result == null) {
                Object next = collectionIt.next();
                result = this.getCombinedFragment(next);
            }
        } else if (newObject instanceof CombinedFragment) {
            result = (CombinedFragment)newObject;
        } else if (newObject instanceof CreateViewAndElementRequest.ViewAndElementDescriptor && ((CreateViewAndElementRequest.ViewAndElementDescriptor)newObject).getCreateElementRequestAdapter() != null && (createElementRequest = (CreateElementRequest)((CreateViewAndElementRequest.ViewAndElementDescriptor)newObject).getCreateElementRequestAdapter().getAdapter(CreateElementRequest.class)) != null && (eObject = createElementRequest.getNewElement()) instanceof CombinedFragment) {
            result = (CombinedFragment)eObject;
        }
        return result;
    }

    protected Rectangle getCreationRectangle(CreateViewAndElementRequest request) {
        Point location = request.getLocation();
        Dimension size = request.getSize();
        if (size == null) {
            return new Rectangle(location.x(), location.y(), 1, 1);
        }
        return new Rectangle(location, size);
    }
}

