/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.tools.SequenceSpecificConnectionTool;
import org.eclipse.swt.widgets.Display;

public class MessageLostFoundConnectionTool
extends SequenceSpecificConnectionTool {
    public MessageLostFoundConnectionTool(List<IElementType> elementTypes) {
        super(elementTypes);
    }

    protected Point getLocation() {
        Point mouseLocation = this.getCurrentInput().getMouseLocation();
        if (this.getCurrentInput().isShiftKeyDown()) {
            return new Point(mouseLocation.x, this.getStartLocation().y);
        }
        return mouseLocation;
    }

    protected boolean updateTargetUnderMouse() {
        if (!this.isTargetLocked()) {
            EditPart editPart = null;
            if (this.getCurrentViewer() != null) {
                editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
            }
            if (editPart instanceof InteractionInteractionCompartmentEditPart) {
                editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
                editPart = editPart.getParent();
            }
            if (editPart != null) {
                editPart = editPart.getTargetEditPart(this.getTargetRequest());
            }
            boolean changed = this.getTargetEditPart() != editPart;
            this.setTargetEditPart(editPart);
            return changed;
        }
        return false;
    }

    protected Command getCommand() {
        if (this.getTargetEditPart() == null) {
            return null;
        }
        return this.getTargetEditPart().getCommand(this.getTargetRequest());
    }

    protected void selectAddedObject(EditPartViewer viewer, Collection objects) {
        final ArrayList editparts = new ArrayList();
        final EditPart[] primaryEP = new EditPart[1];
        for (Object object : objects) {
            if (!(object instanceof IAdaptable)) continue;
            Object editPart = viewer.getEditPartRegistry().get(((IAdaptable)object).getAdapter(View.class));
            if (editPart instanceof IPrimaryEditPart) {
                editparts.add(editPart);
            }
            if (!(editPart instanceof ShapeEditPart)) continue;
            primaryEP[0] = (ShapeEditPart)editPart;
        }
        if (!editparts.isEmpty()) {
            viewer.setSelection((ISelection)new StructuredSelection(editparts));
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (primaryEP[0] == null) {
                        primaryEP[0] = (EditPart)editparts.get(0);
                    }
                    if (primaryEP[0].isActive()) {
                        Request request = new Request((Object)"direct edit");
                        request.getExtendedData().put("Direct Edit After Creation", true);
                        primaryEP[0].performRequest(request);
                    }
                }
            });
        }
    }
}

