/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core;

import java.util.Hashtable;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.osgi.framework.BundleContext;

public class PDebugOptions
implements DebugOptionsListener {
    public static final String DEBUG_MASTER = "/debug/master";
    public static final String DEBUG_MASTER_MORE = "/debug/master/more";
    public static final String DEBUG_MASTER_OUTPUT = "/debug/master/output";
    private static DebugTrace fDebugTrace;
    private static DebugOptions fDebugOptions;
    private static PDebugOptions fPDebugOptions;

    public static void configure(BundleContext context) {
        if (fPDebugOptions == null) {
            fPDebugOptions = new PDebugOptions(context);
        }
    }

    private PDebugOptions(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", PTPDebugCorePlugin.getUniqueIdentifier());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
    }

    public void optionsChanged(DebugOptions options) {
        fDebugOptions = options;
        fDebugTrace = options.newDebugTrace(PTPDebugCorePlugin.getUniqueIdentifier());
    }

    public static boolean isDebugging() {
        return PTPDebugCorePlugin.getDefault().isDebugging();
    }

    public static boolean isDebugging(String option) {
        if (fDebugOptions == null) {
            return false;
        }
        return fDebugOptions.getBooleanOption(String.valueOf(PTPDebugCorePlugin.getUniqueIdentifier()) + option, false);
    }

    public static void setDebugging(String option, boolean value) {
        if (fDebugOptions != null) {
            if (value) {
                fDebugOptions.setDebugEnabled(true);
            }
            fDebugOptions.setOption(option, Boolean.toString(value));
        }
    }

    public static void trace(String message) {
        PDebugOptions.trace(null, message, new String[0]);
    }

    public static void trace(String option, String message, String ... arguments) {
        String traceMsg = message;
        if (arguments.length > 0) {
            traceMsg = NLS.bind((String)message, (Object[])arguments);
        }
        if (option != null && PDebugOptions.isDebugging(option) || PDebugOptions.isDebugging()) {
            System.out.println(traceMsg);
            if (fDebugTrace != null) {
                fDebugTrace.trace(option, traceMsg, null);
            }
        }
    }
}

