/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.util;

import org.eclipse.ptp.internal.etfw.feedback.perfsuite.util.PS_Environment;

public class PS_Debug {
    private static int level = 0;
    public static String prefix = "PS_DEBUG";
    private static String separator = ":";
    public static final int OFF = 0;
    public static final int FATAL = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int VERBOSE = 4;
    private static int CALLER_SFN = 3;

    static {
        int lev = PS_Environment.getNonNegativeInteger("PS_DEBUG");
        if (lev > 0) {
            String sep;
            level = 5;
            boolean sfn_found_at_runtime = false;
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            int i = 0;
            while (i < st.length) {
                if (st[i].getClassName().equals("org.eclipse.ptp.internal.etfw.feedback.perfsuite.util.PS_Debug") && st[i].getMethodName().equals("<clinit>")) {
                    CALLER_SFN = i + 2;
                    sfn_found_at_runtime = true;
                    break;
                }
                ++i;
            }
            String var = "PS_DEBUG_PREFIX";
            String pre = PS_Environment.getString(var);
            if (pre != null) {
                prefix = pre;
                PS_Debug.print(3, "Setting debug prefix to \"" + prefix + "\" according to the environment variable " + var);
            }
            if ((sep = PS_Environment.getString(var = "PS_DEBUG_SEPARATOR")) != null) {
                separator = sep;
                PS_Debug.print(3, "Setting debug separator to " + separator + " according to the environment variable " + var);
            }
            var = "PS_DEBUG";
            PS_Debug.print(3, "Setting debug level to " + lev + " according to the environment variable " + var);
            level = lev;
            if (sfn_found_at_runtime) {
                PS_Debug.print(4, "CALLER_SFN = " + CALLER_SFN + ", found at run time.");
            } else {
                PS_Debug.print(4, "CALLER_SFN = " + CALLER_SFN + ", using the pre-defined value.");
            }
        }
    }

    private static String levelString(int level) {
        String levelString = null;
        if (1 == level) {
            levelString = "FATAL";
        } else if (2 == level) {
            levelString = "WARNING";
        } else if (3 == level) {
            levelString = "INFO";
        } else if (level >= 4) {
            levelString = "VERBOSE";
        }
        return levelString;
    }

    public static void setLevel(int lev) {
        level = lev;
    }

    public static int getLevel() {
        return level;
    }

    public static String getPrefix() {
        return prefix;
    }

    public static void setPrefix(String pre) {
        prefix = pre;
    }

    public static void print(int lev, String msg) {
        if (level < lev || lev <= 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        System.out.println(sb.append(prefix).append(separator).append(PS_Debug.levelString(lev)).append(separator).append(PS_Debug.fileName()).append(separator).append(PS_Debug.methodName()).append(separator).append(PS_Debug.lineNumber()).append(separator).append(msg).toString());
    }

    public static void errorExit(String msg) {
        String separator = ":";
        StringBuilder sb = new StringBuilder();
        sb.append("Error: ");
        if (level > 0) {
            sb.append(PS_Debug.fileName()).append(separator).append(PS_Debug.methodName()).append(separator).append(PS_Debug.lineNumber()).append(separator);
        }
        sb.append(msg).append(".  Exiting...");
        System.err.println(sb.toString());
        System.exit(1);
    }

    private static String fileName() {
        return Thread.currentThread().getStackTrace()[CALLER_SFN].getFileName();
    }

    private static String methodName() {
        return Thread.currentThread().getStackTrace()[CALLER_SFN].getMethodName();
    }

    private static int lineNumber() {
        return Thread.currentThread().getStackTrace()[CALLER_SFN].getLineNumber();
    }
}

